/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.intern.network;

import info.u_team.u_team_core.menu.FluidContainerMenu;
import info.u_team.u_team_core.menu.NeoForgeFluidContainerMenuDelegator;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class ContainerSetFluidSlotMessage
implements CustomPacketPayload {
    public static final CustomPacketPayload.Type<ContainerSetFluidSlotMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"uteamcore", (String)"container_set_fluid_slot"));
    private final int containerId;
    private final int stateId;
    private final int slot;
    private final FluidStack stack;

    public ContainerSetFluidSlotMessage(int containerId, int stateId, int slot, FluidStack stack) {
        this.containerId = containerId;
        this.stateId = stateId;
        this.slot = slot;
        this.stack = stack.copy();
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void write(RegistryFriendlyByteBuf buffer, ContainerSetFluidSlotMessage message) {
        buffer.writeByte(message.containerId);
        buffer.writeVarInt(message.stateId);
        buffer.writeShort(message.slot);
        FluidStack.OPTIONAL_STREAM_CODEC.encode((Object)buffer, (Object)message.stack);
    }

    public static ContainerSetFluidSlotMessage read(RegistryFriendlyByteBuf buffer) {
        byte containerId = buffer.readByte();
        int stateId = buffer.readVarInt();
        short slot = buffer.readShort();
        FluidStack stack = (FluidStack)FluidStack.OPTIONAL_STREAM_CODEC.decode((Object)buffer);
        return new ContainerSetFluidSlotMessage(containerId, stateId, slot, stack);
    }

    public static class Handler {
        public static void handle(ContainerSetFluidSlotMessage message, IPayloadContext context) {
            context.enqueueWork(() -> Handler.testContainerMenu(Minecraft.getInstance().player.containerMenu, message.containerId).ifPresent(menu -> ((NeoForgeFluidContainerMenuDelegator)menu.getDelegator()).setFluid(message.slot, message.stateId, message.stack)));
        }

        private static final Optional<FluidContainerMenu> testContainerMenu(AbstractContainerMenu container, int containerId) {
            if (container instanceof FluidContainerMenu) {
                FluidContainerMenu fluidMenu = (FluidContainerMenu)container;
                if (container.containerId == containerId) {
                    return Optional.of(fluidMenu);
                }
            }
            return Optional.empty();
        }
    }
}

