/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.intern.command.uteamcore;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import info.u_team.u_team_core.util.LevelUtil;
import java.util.Collection;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.DimensionArgument;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.coordinates.Vec3Argument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;

public class DimensionTeleportSubCommand {
    private static final String SUCCESS_TRANSLATION_STRING = "commands.uteamcore.dimteleport.success.";

    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return ((LiteralArgumentBuilder)Commands.literal((String)"dimteleport").requires(source -> source.hasPermission(2))).then(Commands.argument((String)"targets", (ArgumentType)EntityArgument.entities()).then(((RequiredArgumentBuilder)Commands.argument((String)"dimension", (ArgumentType)DimensionArgument.dimension()).executes(context -> DimensionTeleportSubCommand.execute((CommandSourceStack)context.getSource(), EntityArgument.getEntities((CommandContext)context, (String)"targets"), DimensionArgument.getDimension((CommandContext)context, (String)"dimension")))).then(((RequiredArgumentBuilder)Commands.argument((String)"location", (ArgumentType)Vec3Argument.vec3()).executes(context -> DimensionTeleportSubCommand.execute((CommandSourceStack)context.getSource(), EntityArgument.getEntities((CommandContext)context, (String)"targets"), DimensionArgument.getDimension((CommandContext)context, (String)"dimension"), Vec3Argument.getVec3((CommandContext)context, (String)"location")))).then(Commands.argument((String)"yaw", (ArgumentType)FloatArgumentType.floatArg((float)0.0f, (float)360.0f)).then(Commands.argument((String)"pitch", (ArgumentType)FloatArgumentType.floatArg((float)-90.0f, (float)90.0f)).executes(context -> DimensionTeleportSubCommand.execute((CommandSourceStack)context.getSource(), EntityArgument.getEntities((CommandContext)context, (String)"targets"), DimensionArgument.getDimension((CommandContext)context, (String)"dimension"), Vec3Argument.getVec3((CommandContext)context, (String)"location"), FloatArgumentType.getFloat((CommandContext)context, (String)"yaw"), FloatArgumentType.getFloat((CommandContext)context, (String)"pitch"))))))));
    }

    private static int execute(CommandSourceStack source, Collection<? extends Entity> targets, ServerLevel level) {
        targets.forEach(entity -> LevelUtil.teleportEntity(entity, level, entity.position()));
        if (targets.size() == 1) {
            source.sendSuccess(() -> Component.translatable((String)"commands.uteamcore.dimteleport.success.single", (Object[])new Object[]{((Entity)targets.iterator().next()).getDisplayName(), level.dimension().location()}), true);
        } else {
            source.sendSuccess(() -> Component.translatable((String)"commands.uteamcore.dimteleport.success.multiple", (Object[])new Object[]{targets.size(), level.dimension().location()}), true);
        }
        return 0;
    }

    private static int execute(CommandSourceStack source, Collection<? extends Entity> targets, ServerLevel level, Vec3 pos) {
        targets.forEach(entity -> LevelUtil.teleportEntity(entity, level, pos));
        DimensionTeleportSubCommand.sendPositionInfo(source, targets, level, pos);
        return 0;
    }

    private static int execute(CommandSourceStack source, Collection<? extends Entity> targets, ServerLevel level, Vec3 pos, float yaw, float pitch) {
        targets.forEach(entity -> LevelUtil.teleportEntity(entity, level, pos.x(), pos.y(), pos.z(), yaw, pitch));
        DimensionTeleportSubCommand.sendPositionInfo(source, targets, level, pos);
        return 0;
    }

    private static void sendPositionInfo(CommandSourceStack source, Collection<? extends Entity> targets, ServerLevel level, Vec3 pos) {
        if (targets.size() == 1) {
            source.sendSuccess(() -> Component.translatable((String)"commands.uteamcore.dimteleport.success.position.single", (Object[])new Object[]{((Entity)targets.iterator().next()).getDisplayName(), level.dimension().location(), pos.x, pos.y, pos.z}), true);
        } else {
            source.sendSuccess(() -> Component.translatable((String)"commands.uteamcore.dimteleport.success.position.multiple", (Object[])new Object[]{targets.size(), level.dimension().location(), pos.x, pos.y, pos.z}), true);
        }
    }
}

