/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.impl.common;

import info.u_team.u_team_core.api.network.NetworkContext;
import info.u_team.u_team_core.api.network.NetworkEnvironment;
import info.u_team.u_team_core.api.network.NetworkHandler;
import info.u_team.u_team_core.api.network.NetworkMessage;
import info.u_team.u_team_core.api.network.NetworkPayload;
import info.u_team.u_team_core.util.NetworkUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.minecraft.network.Connection;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CommonNetworkHandler
implements NetworkHandler {
    protected static final Logger LOGGER = LoggerFactory.getLogger((String)"NetworkHandler");
    protected final ResourceLocation networkId;
    protected final int protocolVersion;
    protected final Map<CustomPacketPayload.Type<?>, MessagePacketPayload<?>> messages;

    protected CommonNetworkHandler(ResourceLocation networkId, int protocolVersion) {
        this.networkId = networkId;
        this.protocolVersion = protocolVersion;
        this.messages = new HashMap();
    }

    public <M> NetworkMessage<M> createNetworkMessage(MessagePacketPayload<M> messagePayload) {
        return new CommonNetworkMessage<M>(messagePayload);
    }

    @Override
    public <M> NetworkMessage<M> register(String id, NetworkPayload<M> payload) {
        ResourceLocation messageId = this.networkId.withSuffix("/" + id);
        MessagePacketPayload<M> messagePayload = new MessagePacketPayload<M>(messageId, payload);
        if (this.messages.put(messagePayload.type, messagePayload) != null) {
            throw new IllegalArgumentException("Duplicate message id " + String.valueOf(messageId));
        }
        return this.createNetworkMessage(messagePayload);
    }

    @Override
    public ResourceLocation getNetworkId() {
        return this.networkId;
    }

    @Override
    public int getProtocolVersion() {
        return this.protocolVersion;
    }

    protected static class CommonNetworkMessage<M>
    implements NetworkMessage<M> {
        protected final MessagePacketPayload<M> messagePayload;

        protected CommonNetworkMessage(MessagePacketPayload<M> messagePayload) {
            this.messagePayload = messagePayload;
        }

        @Override
        public CustomPacketPayload packet(M message) {
            return this.messagePayload.createCustomPacketPayload(message);
        }

        @Override
        public Packet<?> packet(NetworkEnvironment toEnvironment, M message) {
            CustomPacketPayload payload = this.packet(message);
            return switch (toEnvironment) {
                default -> throw new MatchException(null, null);
                case NetworkEnvironment.CLIENT -> NetworkUtil.createClientBoundPacket(payload);
                case NetworkEnvironment.SERVER -> NetworkUtil.createServerBoundPacket(payload);
            };
        }

        @Override
        public void sendToPlayer(ServerPlayer player, M message) {
            if (this.messagePayload.canWrite(NetworkEnvironment.CLIENT)) {
                NetworkUtil.sendToPlayer(player, this.packet(NetworkEnvironment.CLIENT, message));
            }
        }

        @Override
        public void sendToConnection(Connection connection, M message) {
            if (this.messagePayload.canWrite(NetworkEnvironment.CLIENT)) {
                NetworkUtil.sendToConnection(connection, this.packet(NetworkEnvironment.CLIENT, message));
            }
        }

        @Override
        public void sendToServer(M message) {
            if (this.messagePayload.canWrite(NetworkEnvironment.SERVER)) {
                NetworkUtil.sendToServer(this.packet(NetworkEnvironment.SERVER, message));
            }
        }
    }

    protected static class MessagePacketPayload<M> {
        private final CustomPacketPayload.Type<CustomPacketPayload> type;
        private final StreamCodec<? super RegistryFriendlyByteBuf, CustomPacketPayload> streamCodec;
        private final NetworkPayload<M> payload;

        private MessagePacketPayload(ResourceLocation messageId, NetworkPayload<M> payload) {
            this.payload = payload;
            this.type = new CustomPacketPayload.Type(messageId);
            this.streamCodec = this.cast((StreamCodec<RegistryFriendlyByteBuf, CustomPacketPayload>)payload.streamCodec().map(x$0 -> new CustomPacketPayloadImpl(x$0), CustomPacketPayloadImpl::getMessage));
        }

        public NetworkPayload<M> payload() {
            return this.payload;
        }

        public CustomPacketPayload.Type<CustomPacketPayload> type() {
            return this.type;
        }

        public StreamCodec<? super RegistryFriendlyByteBuf, CustomPacketPayload> streamCodec() {
            return this.streamCodec;
        }

        public void handle(CustomPacketPayload customPacketPayload, NetworkContext context) {
            this.handle(this.cast(customPacketPayload).getMessage(), context);
        }

        private CustomPacketPayload createCustomPacketPayload(M message) {
            return new CustomPacketPayloadImpl(message);
        }

        private boolean canWrite(NetworkEnvironment handlerEnvironment) {
            if (!this.payload.handlerEnvironment().isValid(handlerEnvironment)) {
                LOGGER.error("Failed to write message to channel {} because not handler is defined on the {} environment. Expected {} environment", new Object[]{this.type.id(), handlerEnvironment, this.payload.handlerEnvironment()});
                return false;
            }
            return true;
        }

        private void handle(M message, NetworkContext context) {
            if (message == null) {
                return;
            }
            NetworkEnvironment current = context.getEnvironment();
            if (!this.payload.handlerEnvironment().isValid(current)) {
                LOGGER.error("Message {} in channel {} cannot be handled on the {} environment. Expected {} environment", new Object[]{message.getClass(), this.type.id(), current, this.payload.handlerEnvironment()});
                return;
            }
            try {
                this.payload.handle(message, context);
            }
            catch (Exception ex) {
                LOGGER.error("Failed to handle message {} in channel {}", new Object[]{message.getClass(), this.type.id(), ex});
            }
        }

        private StreamCodec<? super RegistryFriendlyByteBuf, CustomPacketPayload> cast(StreamCodec<? super RegistryFriendlyByteBuf, ? extends CustomPacketPayload> streamCodec) {
            return streamCodec;
        }

        private CustomPacketPayloadImpl cast(CustomPacketPayload customPacketPayload) {
            return (CustomPacketPayloadImpl)customPacketPayload;
        }

        private class CustomPacketPayloadImpl
        implements CustomPacketPayload {
            private final M message;

            private CustomPacketPayloadImpl(M message) {
                this.message = message;
            }

            public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
                return MessagePacketPayload.this.type;
            }

            private M getMessage() {
                return this.message;
            }
        }
    }

    protected static abstract class CommonNetworkContext<M>
    implements NetworkContext {
        protected final MessagePacketPayload<M> messagePayload;

        protected CommonNetworkContext(MessagePacketPayload<M> messagePayload) {
            this.messagePayload = messagePayload;
        }

        protected abstract CompletableFuture<Void> execute(Runnable var1);

        @Override
        public final CompletableFuture<Void> executeOnMainThread(Runnable runnable) {
            return this.execute(() -> {
                try {
                    runnable.run();
                }
                catch (Exception ex) {
                    LOGGER.error("Failed to handle synchronized message in channel {}", (Object)this.messagePayload.type().id(), (Object)ex);
                }
            });
        }
    }
}

