/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.gui.elements;

import info.u_team.u_team_core.api.gui.BackgroundColorProvider;
import info.u_team.u_team_core.api.gui.Scalable;
import info.u_team.u_team_core.api.gui.ScaleProvider;
import info.u_team.u_team_core.api.gui.TextProvider;
import info.u_team.u_team_core.api.gui.TextureProvider;
import info.u_team.u_team_core.api.gui.WidgetRenderable;
import info.u_team.u_team_core.gui.elements.WidgetTextureProvider;
import info.u_team.u_team_core.util.RGBA;
import info.u_team.u_team_core.util.WidgetUtil;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;

public class UButton
extends Button
implements WidgetRenderable,
BackgroundColorProvider,
TextProvider,
Scalable,
ScaleProvider {
    protected static final Button.OnPress EMTPY_PRESSABLE = button -> {};
    protected static final Button.CreateNarration DEFAULT_NARRATION = Button.DEFAULT_NARRATION;
    protected static final RGBA WHITE = RGBA.WHITE;
    protected static final RGBA LIGHT_GRAY = new RGBA(-1600085761);
    protected TextureProvider buttonTextureProvider = new WidgetTextureProvider(SPRITES, () -> ((UButton)this).isActive(), () -> ((UButton)this).isHoveredOrFocused());
    protected RGBA buttonColor = WHITE;
    protected RGBA textColor = WHITE;
    protected RGBA disabledTextColor = LIGHT_GRAY;
    protected float scale = 1.0f;

    public UButton(int x, int y, int width, int height, Component text) {
        this(x, y, width, height, text, EMTPY_PRESSABLE);
    }

    public UButton(int x, int y, int width, int height, Component text, Button.OnPress pressable) {
        this(x, y, width, height, text, pressable, DEFAULT_NARRATION);
    }

    public UButton(int x, int y, int width, int height, Component text, Button.OnPress pressable, Button.CreateNarration narration) {
        super(x, y, width, height, text, pressable, narration);
    }

    public void setPressable(Button.OnPress pressable) {
        this.onPress = pressable;
    }

    public void setPressable(Runnable runnable) {
        this.onPress = button -> runnable.run();
    }

    public void setCreateNarration(Button.CreateNarration narration) {
        this.createNarration = narration;
    }

    public RGBA getButtonColor() {
        return this.buttonColor;
    }

    public void setButtonColor(RGBA buttonColor) {
        this.buttonColor = buttonColor;
    }

    public RGBA getTextColor() {
        return this.textColor;
    }

    public void setTextColor(RGBA textColor) {
        this.textColor = textColor;
    }

    public RGBA getDisabledTextColor() {
        return this.disabledTextColor;
    }

    public void setDisabledTextColor(RGBA disabledTextColor) {
        this.disabledTextColor = disabledTextColor;
    }

    @Override
    public float getScale() {
        return this.scale;
    }

    @Override
    public void setScale(float scale) {
        this.scale = scale;
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        WidgetUtil.renderWidget(this, guiGraphics, mouseX, mouseY, partialTick);
    }

    @Override
    public void renderWidgetTexture(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        WidgetUtil.renderButtonLikeTexture(this, this.buttonTextureProvider, guiGraphics, mouseX, mouseY, partialTick);
    }

    @Override
    public void renderBehind(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
    }

    @Override
    public void renderBefore(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        WidgetUtil.renderText(this, guiGraphics, mouseX, mouseY, partialTick);
    }

    @Override
    public RGBA getCurrentBackgroundColor(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        return this.buttonColor;
    }

    @Override
    public Component getCurrentText() {
        return this.getMessage();
    }

    @Override
    public RGBA getCurrentTextColor(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        return this.active ? this.textColor : this.disabledTextColor;
    }

    @Override
    public float getCurrentScale(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        return this.scale;
    }
}

