/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.gui.elements;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.renderer.RenderType;

public abstract class ScrollableList<T extends ObjectSelectionList.Entry<T>>
extends ObjectSelectionList<T> {
    protected int sideDistance;
    protected boolean renderTransparentBorder;
    protected int transparentBorderSize;

    public ScrollableList(int x, int y, int width, int height, int slotHeight, int sideDistance) {
        super(Minecraft.getInstance(), width, height, y, slotHeight);
        this.setX(x);
        this.sideDistance = sideDistance;
        this.transparentBorderSize = 4;
    }

    public int getSideDistance() {
        return this.sideDistance;
    }

    public void setSideDistance(int sideDistance) {
        this.sideDistance = sideDistance;
    }

    public boolean isRenderTransparentBorder() {
        return this.renderTransparentBorder;
    }

    public void setRenderTransparentBorder(boolean renderTransparentBorder) {
        this.renderTransparentBorder = renderTransparentBorder;
    }

    public float getTransparentBorderSize() {
        return this.transparentBorderSize;
    }

    public void setTransparentBorderSize(int transparentBorderSize) {
        this.transparentBorderSize = transparentBorderSize;
    }

    public int getRowWidth() {
        return this.width - this.sideDistance;
    }

    protected int getScrollbarPosition() {
        return this.x + this.width - 5;
    }

    protected void renderListItems(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.renderListItems(guiGraphics, mouseX, mouseY, partialTick);
        if (this.renderTransparentBorder) {
            guiGraphics.fillGradient(RenderType.guiOverlay(), this.getX(), this.getY(), this.getRight(), this.getY() + this.transparentBorderSize, -16777216, 0, 0);
            guiGraphics.fillGradient(RenderType.guiOverlay(), this.getX(), this.getBottom() - this.transparentBorderSize, this.getRight(), this.getBottom(), 0, -16777216, 0);
        }
    }
}

