/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.gui.elements;

import com.mojang.blaze3d.vertex.PoseStack;
import info.u_team.u_team_core.api.gui.Scalable;
import info.u_team.u_team_core.api.gui.ScaleProvider;
import info.u_team.u_team_core.gui.elements.UEditBox;
import info.u_team.u_team_core.util.RGBA;
import info.u_team.u_team_core.util.WidgetUtil;
import net.minecraft.Util;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;

public class ScalableEditBox
extends UEditBox
implements Scalable,
ScaleProvider {
    protected float scale;

    public ScalableEditBox(Font font, int x, int y, int width, int height, UEditBox previousEditBox, Component title, float scale) {
        super(font, x, y, width, height, previousEditBox, title);
        this.scale = scale;
    }

    @Override
    public float getScale() {
        return this.scale;
    }

    @Override
    public void setScale(float scale) {
        this.scale = scale;
    }

    @Override
    public void renderBefore(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        float currentScale = this.getCurrentScale(guiGraphics, mouseX, mouseY, partialTick);
        float positionFactor = 1.0f / this.scale;
        PoseStack poseStack = guiGraphics.pose();
        poseStack.pushPose();
        poseStack.scale(currentScale, currentScale, 0.0f);
        RGBA currentTextColor = WidgetUtil.respectWidgetAlpha((AbstractWidget)this, this.getCurrentTextColor(guiGraphics, mouseX, mouseY, partialTick));
        String currentText = this.font.plainSubstrByWidth(this.value.substring(this.displayPos), (int)((float)this.getInnerWidth() * positionFactor));
        int cursorOffset = this.cursorPos - this.displayPos;
        int selectionOffset = Math.min(this.highlightPos - this.displayPos, currentText.length());
        boolean isCursorInText = cursorOffset >= 0 && cursorOffset <= currentText.length();
        boolean shouldCursorBlink = this.isFocused() && (Util.getMillis() - this.focusedTime) / 300L % 2L == 0L && isCursorInText;
        boolean isCursorInTheMiddle = this.cursorPos < this.value.length() || this.value.length() >= this.maxLength;
        int xOffset = (int)((float)(this.bordered ? this.x + 4 : this.x) * positionFactor);
        int yOffset = (int)((this.bordered ? (float)this.y + ((float)this.height - 8.0f * currentScale) / 2.0f : (float)this.y) * positionFactor);
        int leftRenderedTextX = xOffset;
        if (!currentText.isEmpty()) {
            String firstTextPart = isCursorInText ? currentText.substring(0, cursorOffset) : currentText;
            leftRenderedTextX = guiGraphics.drawString(this.font, (FormattedCharSequence)this.formatter.apply(firstTextPart, this.displayPos), xOffset, yOffset, currentTextColor.getColorARGB());
        }
        int rightRenderedTextX = leftRenderedTextX;
        if (!isCursorInText) {
            rightRenderedTextX = cursorOffset > 0 ? (int)((float)xOffset + (float)this.width * positionFactor) : xOffset;
        } else if (isCursorInTheMiddle) {
            rightRenderedTextX = leftRenderedTextX - 1;
            --leftRenderedTextX;
        }
        if (!currentText.isEmpty() && isCursorInText && cursorOffset < currentText.length()) {
            guiGraphics.drawString(this.font, (FormattedCharSequence)this.formatter.apply(currentText.substring(cursorOffset), this.cursorPos), leftRenderedTextX, yOffset, currentTextColor.getColorARGB());
        }
        if (this.hint != null && currentText.isEmpty() && !this.isFocused()) {
            guiGraphics.drawString(this.font, this.hint, leftRenderedTextX, yOffset, WidgetUtil.respectWidgetAlpha((AbstractWidget)this, this.getCurrentHintTextColor(guiGraphics, mouseX, mouseY, partialTick)).getColorARGB());
        }
        if (!isCursorInTheMiddle && this.suggestion != null) {
            guiGraphics.drawString(this.font, this.suggestion, rightRenderedTextX - 1, yOffset, WidgetUtil.respectWidgetAlpha((AbstractWidget)this, this.getCurrentSuggestionTextColor(guiGraphics, mouseX, mouseY, partialTick)).getColorARGB());
        }
        if (shouldCursorBlink) {
            if (isCursorInTheMiddle) {
                guiGraphics.fill(rightRenderedTextX, yOffset - 1, rightRenderedTextX + 1, yOffset + 1 + 9, WidgetUtil.respectWidgetAlpha((AbstractWidget)this, this.getCurrentCursorColor(guiGraphics, mouseX, mouseY, partialTick)).getColorARGB());
            } else {
                guiGraphics.drawString(this.font, "_", rightRenderedTextX, yOffset, currentTextColor.getColorARGB());
            }
        }
        poseStack.popPose();
        if (selectionOffset != cursorOffset) {
            int selectedX = xOffset + this.font.width(currentText.substring(0, selectionOffset));
            this.renderHighlight(guiGraphics, (int)((float)rightRenderedTextX * currentScale), (int)((float)(yOffset - 1) * currentScale), (int)((float)(selectedX - 1) * currentScale), (int)((float)(yOffset + 1 + 9) * currentScale));
        }
    }

    public void onClick(double mouseX, double mouseY) {
        int clickOffset = Mth.floor((double)mouseX) - this.x;
        if (this.bordered) {
            clickOffset -= 4;
        }
        clickOffset = (int)((float)clickOffset / this.getCurrentScale());
        String currentText = this.font.plainSubstrByWidth(this.value.substring(this.displayPos), (int)((float)(this.getInnerWidth() * 1) / this.getCurrentScale()));
        this.moveCursorTo(this.font.plainSubstrByWidth(currentText, clickOffset).length() + this.displayPos, Screen.hasShiftDown());
    }

    public void setHighlightPos(int position) {
        int valueLength = this.value.length();
        this.highlightPos = Mth.clamp((int)position, (int)0, (int)valueLength);
        if (this.font != null) {
            if (this.displayPos > valueLength) {
                this.displayPos = valueLength;
            }
            int scaledInnerWidth = (int)((float)(this.getInnerWidth() * 1) / this.getCurrentScale());
            String currentText = this.font.plainSubstrByWidth(this.value.substring(this.displayPos), scaledInnerWidth);
            int offset = currentText.length() + this.displayPos;
            if (this.highlightPos == this.displayPos) {
                this.displayPos -= this.font.plainSubstrByWidth(this.value, scaledInnerWidth, true).length();
            }
            if (this.highlightPos > offset) {
                this.displayPos += this.highlightPos - offset;
            } else if (this.highlightPos <= this.displayPos) {
                this.displayPos -= this.displayPos - this.highlightPos;
            }
            this.displayPos = Mth.clamp((int)this.displayPos, (int)0, (int)valueLength);
        }
    }

    @Override
    public float getCurrentScale(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        return this.getCurrentScale();
    }

    public float getCurrentScale() {
        return this.scale;
    }
}

