/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.gui.elements;

import info.u_team.u_team_core.util.RGBA;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvents;

public class ProgressBar
implements GuiEventListener,
Renderable {
    protected Supplier<Double> progress;
    protected Consumer<Double> click;
    protected int width = 200;
    protected int height = 5;
    protected int x;
    protected int y;
    protected RGBA backgroundColor;
    protected RGBA progressColor;
    protected boolean enabled = true;
    protected boolean visible = true;
    protected boolean hovered;
    protected boolean focused;

    public ProgressBar(int x, int y, int width, int height, RGBA backgroundColor, RGBA progressColor, Supplier<Double> progress, Consumer<Double> click) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.backgroundColor = backgroundColor;
        this.progressColor = progressColor;
        this.progress = progress;
        this.click = click;
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (this.visible) {
            this.hovered = mouseX >= this.x && mouseY >= this.y && mouseX < this.x + this.width && mouseY < this.y + this.height;
            guiGraphics.fill(this.x, this.y, this.x + this.width, this.y + this.height, this.backgroundColor.getColorARGB());
            guiGraphics.fill(this.x, this.y, (int)((double)this.x + this.progress.get() * (double)this.width), this.y + this.height, this.progressColor.getColorARGB());
        }
    }

    public void onClick(double mouseX, double mouseY) {
        if (this.click != null) {
            this.click.accept((mouseX - (double)this.x) / (double)this.width);
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (button == 0 && this.isPressable(mouseX, mouseY)) {
            this.playPressSound(Minecraft.getInstance().getSoundManager());
            this.onClick(mouseX, mouseY);
            return true;
        }
        return false;
    }

    protected boolean isPressable(double mouseX, double mouseY) {
        return this.enabled && this.visible && mouseX >= (double)this.x && mouseY >= (double)this.y && mouseX < (double)(this.x + this.width) && mouseY < (double)(this.y + this.height);
    }

    public void playPressSound(SoundManager soundHandler) {
        soundHandler.play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
    }

    public void setProgressSupplier(Supplier<Double> progress) {
        this.progress = progress;
    }

    public double getProgress() {
        return this.progress.get();
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getX() {
        return this.x;
    }

    public void setX(int x) {
        this.x = x;
    }

    public int getY() {
        return this.y;
    }

    public void setY(int y) {
        this.y = y;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public boolean isHovered() {
        return this.hovered;
    }

    public RGBA getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(RGBA backGroundColor) {
        this.backgroundColor = backGroundColor;
    }

    public RGBA getProgressColor() {
        return this.progressColor;
    }

    public void setProgressColor(RGBA progressColor) {
        this.progressColor = progressColor;
    }

    public void setClick(Consumer<Double> click) {
        this.click = click;
    }

    public void setFocused(boolean focused) {
        this.focused = focused;
    }

    public boolean isFocused() {
        return this.focused;
    }
}

