/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.gui.elements;

import info.u_team.u_team_core.gui.elements.UButton;
import info.u_team.u_team_core.util.RGBA;
import info.u_team.u_team_core.util.RenderUtil;
import info.u_team.u_team_core.util.WidgetUtil;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class ImageButton
extends UButton {
    protected ResourceLocation image;
    protected RGBA imageColor;

    public ImageButton(int x, int y, int width, int height, ResourceLocation image) {
        this(x, y, width, height, image, EMTPY_PRESSABLE);
    }

    public ImageButton(int x, int y, int width, int height, ResourceLocation image, Button.OnPress pessable) {
        super(x, y, width, height, (Component)Component.empty(), pessable);
        this.image = image;
        this.imageColor = WHITE;
    }

    public ResourceLocation getImage() {
        return this.image;
    }

    public void setImage(ResourceLocation image) {
        this.image = image;
    }

    public RGBA getImageColor() {
        return this.imageColor;
    }

    public void setImageColor(RGBA imageColor) {
        this.imageColor = imageColor;
    }

    @Override
    public void renderBefore(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        ResourceLocation image = this.getCurrentImage(guiGraphics, mouseX, mouseY, partialTick);
        RGBA color = WidgetUtil.respectWidgetAlpha((AbstractWidget)this, this.getCurrentImageColor(guiGraphics, mouseX, mouseY, partialTick));
        RenderUtil.drawTexturedQuad(guiGraphics.pose(), this.x + 2, this.x + this.width - 2, this.y + 2, this.y + this.height - 2, 0.0f, 1.0f, 0.0f, 1.0f, 0.0f, image, color);
    }

    public ResourceLocation getCurrentImage(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        return this.image;
    }

    public RGBA getCurrentImageColor(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        return this.imageColor;
    }
}

