/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.gui.elements;

import com.mojang.blaze3d.vertex.PoseStack;
import info.u_team.u_team_core.gui.elements.UButton;
import info.u_team.u_team_core.gui.elements.WidgetTextureProvider;
import info.u_team.u_team_core.util.FontUtil;
import info.u_team.u_team_core.util.WidgetUtil;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Checkbox;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;

public class CheckboxButton
extends UButton {
    protected static final WidgetSprites CHECKBOX_SPRITES = new WidgetSprites(Checkbox.CHECKBOX_SELECTED_SPRITE, Checkbox.CHECKBOX_HIGHLIGHTED_SPRITE, Checkbox.CHECKBOX_SELECTED_HIGHLIGHTED_SPRITE, Checkbox.CHECKBOX_SPRITE);
    protected boolean checked;
    protected boolean drawText;
    protected boolean leftSideText;
    protected boolean dropShadow;

    public CheckboxButton(int x, int y, int width, int height, Component text, boolean checked, boolean drawText) {
        this(x, y, width, height, text, checked, drawText, EMTPY_PRESSABLE);
    }

    public CheckboxButton(int x, int y, int width, int height, Component text, boolean checked, boolean drawText, Button.OnPress pessable) {
        super(x, y, width, height, text, pessable);
        this.checked = checked;
        this.drawText = drawText;
        this.buttonTextureProvider = new WidgetTextureProvider(CHECKBOX_SPRITES, this::isChecked, () -> ((CheckboxButton)this).isHoveredOrFocused());
    }

    public boolean isChecked() {
        return this.checked;
    }

    public void setChecked(boolean checked) {
        this.checked = checked;
    }

    public boolean isDrawText() {
        return this.drawText;
    }

    public void setDrawText(boolean drawText) {
        this.drawText = drawText;
    }

    public boolean isLeftSideText() {
        return this.leftSideText;
    }

    public void setLeftSideText(boolean leftSideText) {
        this.leftSideText = leftSideText;
    }

    public void toggle() {
        this.checked = !this.checked;
    }

    public void onPress() {
        this.toggle();
        super.onPress();
    }

    @Override
    public void renderBefore(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (this.drawText) {
            Font font = this.getCurrentTextFont();
            Component message = this.getCurrentText();
            if (message != CommonComponents.EMPTY) {
                float currentScale = this.getCurrentScale(guiGraphics, mouseX, mouseY, partialTick);
                float positionFactor = 1.0f / currentScale;
                float yStart = (float)(this.y + (int)((float)this.height - 8.0f * currentScale) / 2) * positionFactor;
                float xStart = this.leftSideText ? ((float)this.x - ((float)font.width((FormattedText)message) * currentScale + 4.0f)) * positionFactor : (float)(this.x + this.width + 4) * positionFactor;
                int color = WidgetUtil.respectWidgetAlpha((AbstractWidget)this, this.getCurrentTextColor(guiGraphics, mouseY, mouseY, partialTick)).getColorARGB();
                PoseStack poseStack = guiGraphics.pose();
                poseStack.pushPose();
                poseStack.scale(currentScale, currentScale, 0.0f);
                FontUtil.drawString(guiGraphics, font, this.getCurrentText(), xStart, yStart, color, this.dropShadow);
                poseStack.popPose();
            }
        }
    }

    public void updateWidgetNarration(NarrationElementOutput output) {
        output.add(NarratedElementType.TITLE, (Component)this.createNarrationMessage());
        if (this.active) {
            if (this.isFocused()) {
                output.add(NarratedElementType.USAGE, (Component)Component.translatable((String)"narration.checkbox.usage.focused"));
            } else {
                output.add(NarratedElementType.USAGE, (Component)Component.translatable((String)"narration.checkbox.usage.hovered"));
            }
        }
    }
}

