/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.data;

import info.u_team.u_team_core.data.CommonDataProvider;
import info.u_team.u_team_core.data.GenerationData;
import info.u_team.u_team_core.util.ReflectionUtil;
import java.lang.reflect.Field;
import java.util.function.Function;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.data.tags.IntrinsicHolderTagsProvider;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagBuilder;
import net.minecraft.tags.TagEntry;
import net.minecraft.tags.TagKey;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public abstract class CommonTagsProvider<T>
extends IntrinsicHolderTagsProvider<T>
implements CommonDataProvider<HolderLookup.Provider> {
    private static final Field RESOURCE_TYPE_FIELD = ReflectionUtil.findField(TagsProvider.class, "resourceType");
    private final GenerationData generationData;
    protected final ExistingFileHelper.IResourceType resourceType;

    public CommonTagsProvider(GenerationData generationData, ResourceKey<? extends Registry<T>> registryKey, Function<T, ResourceKey<T>> keyExtractor) {
        super(generationData.output(), registryKey, generationData.registriesFuture(), keyExtractor, generationData.modid(), generationData.existingFileHelper());
        this.generationData = generationData;
        this.resourceType = (ExistingFileHelper.IResourceType)ReflectionUtil.getValue(RESOURCE_TYPE_FIELD, this);
    }

    @Override
    public GenerationData getGenerationData() {
        return this.generationData;
    }

    protected void addTags(HolderLookup.Provider registries) {
        this.register(registries);
    }

    protected TagBuilder getOrCreateRawBuilder(TagKey<T> tagKey) {
        return this.builders.computeIfAbsent(tagKey.location(), location -> {
            this.existingFileHelper.trackGenerated(location, this.resourceType);
            return new UniqueTagBuilder();
        });
    }

    private static class UniqueTagBuilder
    extends TagBuilder {
        private UniqueTagBuilder() {
        }

        public TagBuilder add(TagEntry entry) {
            boolean duplicate = this.entries.stream().anyMatch(otherEntry -> otherEntry.getId().equals((Object)entry.getId()) && otherEntry.tag == entry.tag);
            if (!duplicate) {
                return super.add(entry);
            }
            return this;
        }
    }
}

