/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.data;

import com.google.common.collect.Streams;
import info.u_team.u_team_core.data.CommonDataProvider;
import info.u_team.u_team_core.data.GenerationData;
import info.u_team.u_team_core.util.RegistryUtil;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ItemModelProvider;
import net.neoforged.neoforge.client.model.generators.ModelFile;

public abstract class CommonItemModelProvider
extends ItemModelProvider
implements CommonDataProvider.NoParam {
    private final GenerationData generationData;

    public CommonItemModelProvider(GenerationData generationData) {
        super(generationData.output(), generationData.modid(), generationData.existingFileHelper());
        this.generationData = generationData;
    }

    @Override
    public GenerationData getGenerationData() {
        return this.generationData;
    }

    protected final void registerModels() {
        this.register(null);
    }

    public String getName() {
        return "Item-Model: " + this.nameSuffix();
    }

    protected void simpleGenerated(ItemLike provider) {
        this.simpleParent(provider, "item/generated");
    }

    protected void simpleHandheld(ItemLike provider) {
        this.simpleParent(provider, "item/handheld");
    }

    protected void spawnEgg(ItemLike provider) {
        this.withExistingParent(RegistryUtil.getBuiltInRegistry(Registries.ITEM).getKey((Object)provider.asItem()).getPath(), "item/template_spawn_egg");
    }

    protected void simpleParent(ItemLike provider, String parent) {
        String registryPath = RegistryUtil.getBuiltInRegistry(Registries.ITEM).getKey((Object)provider.asItem()).getPath();
        ((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(registryPath)).parent((ModelFile)new ModelFile.UncheckedModelFile(parent))).texture("layer0", "item/" + registryPath);
    }

    protected void simpleBlock(Block block) {
        ResourceLocation registryName = RegistryUtil.getBuiltInRegistry(Registries.BLOCK).getKey((Object)block);
        ((ItemModelBuilder)this.getBuilder(registryName.getPath())).parent((ModelFile)new ModelFile.UncheckedModelFile(ResourceLocation.fromNamespaceAndPath((String)registryName.getNamespace(), (String)("block/" + registryName.getPath()))));
    }

    protected void iterateItems(Iterable<? extends Supplier<? extends Item>> iterable, Consumer<ItemLike> item) {
        Streams.stream(iterable).map(Supplier::get).forEach(item);
    }

    protected void iterateBlocks(Iterable<? extends Supplier<? extends Block>> iterable, Consumer<ItemLike> item) {
        Streams.stream(iterable).map(Supplier::get).forEach(item);
    }

    protected String getPath(ItemLike provider) {
        return RegistryUtil.getBuiltInRegistry(Registries.ITEM).getKey((Object)provider.asItem()).getPath();
    }
}

