/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import info.u_team.u_team_core.data.CommonDataProvider;
import info.u_team.u_team_core.data.GenerationData;
import info.u_team.u_team_core.util.CastUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.common.conditions.WithConditions;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;

public abstract class CommonGlobalLootModifierProvider
implements CommonDataProvider<GlobalLootModifierRegister> {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final GenerationData generationData;
    private final PackOutput.PathProvider pathProvider;
    protected boolean replace;

    public CommonGlobalLootModifierProvider(GenerationData generationData) {
        this.generationData = generationData;
        this.pathProvider = generationData.output().createPathProvider(PackOutput.Target.DATA_PACK, "loot_modifiers");
    }

    @Override
    public GenerationData getGenerationData() {
        return this.generationData;
    }

    public CompletableFuture<?> run(CachedOutput cache) {
        return this.withRegistries(registries -> {
            TreeMap serializers = new TreeMap();
            this.register(new GlobalLootModifierRegister(){
                final /* synthetic */ HolderLookup.Provider val$registries;
                final /* synthetic */ Map val$serializers;
                {
                    this.val$registries = provider;
                    this.val$serializers = map;
                }

                @Override
                public HolderLookup.Provider registries() {
                    return this.val$registries;
                }

                @Override
                public void register(String name, WithConditions<? extends IGlobalLootModifier> modifier) {
                    this.val$serializers.put(name, (WithConditions)CastUtil.uncheckedCast(modifier));
                }
            });
            ArrayList futures = new ArrayList();
            List entries = serializers.entrySet().stream().map(entry -> {
                String name = (String)entry.getKey();
                ResourceLocation location = ResourceLocation.fromNamespaceAndPath((String)this.modid(), (String)name);
                futures.add(this.saveData(cache, (HolderLookup.Provider)registries, IGlobalLootModifier.CONDITIONAL_CODEC, Optional.of((WithConditions)entry.getValue()), this.pathProvider.json(location)));
                return location;
            }).map(ResourceLocation::toString).collect(Collectors.toList());
            JsonObject json = new JsonObject();
            json.addProperty("replace", Boolean.valueOf(this.replace));
            json.add("entries", GSON.toJsonTree(entries));
            futures.add(this.saveData(cache, (JsonElement)json, this.pathProvider.json(ResourceLocation.fromNamespaceAndPath((String)"neoforge", (String)"global_loot_modifiers"))));
            return CompletableFuture.allOf((CompletableFuture[])futures.toArray(CompletableFuture[]::new));
        });
    }

    protected void replacing() {
        this.replace = true;
    }

    public String getName() {
        return "Global-Loot-Modifier: " + this.nameSuffix();
    }

    public static interface GlobalLootModifierRegister {
        public void register(String var1, WithConditions<? extends IGlobalLootModifier> var2);

        public HolderLookup.Provider registries();
    }
}

