/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.api.fluid;

import info.u_team.u_team_core.api.InteractionType;
import it.unimi.dsi.fastutil.ints.Int2ObjectFunction;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.util.function.IntSupplier;
import net.neoforged.neoforge.fluids.FluidStack;

public class ExtendedFluidHandlerUtils {
    public static FluidStack insert(FluidStack stack, InteractionType action, IntSupplier tankCount, Int2ObjectFunction<FluidStack> inTankGetter, InsertFluid insertFluid) {
        FluidStack remainder;
        int tank;
        int tanks = tankCount.getAsInt();
        if (tanks == 1) {
            return insertFluid.insert(0, stack, action);
        }
        IntArrayList matchingTanks = new IntArrayList();
        IntArrayList emptyTanks = new IntArrayList();
        for (int tank2 = 0; tank2 < tanks; ++tank2) {
            FluidStack inTank = (FluidStack)inTankGetter.get(tank2);
            if (inTank.isEmpty()) {
                emptyTanks.add(tank2);
                continue;
            }
            if (!FluidStack.isSameFluidSameComponents((FluidStack)inTank, (FluidStack)stack)) continue;
            matchingTanks.add(tank2);
        }
        FluidStack toInsert = stack;
        IntListIterator intListIterator = matchingTanks.iterator();
        while (intListIterator.hasNext()) {
            tank = (Integer)intListIterator.next();
            remainder = insertFluid.insert(tank, toInsert, action);
            if (remainder.isEmpty()) {
                return FluidStack.EMPTY;
            }
            toInsert = remainder;
        }
        intListIterator = emptyTanks.iterator();
        while (intListIterator.hasNext()) {
            tank = (Integer)intListIterator.next();
            remainder = insertFluid.insert(tank, toInsert, action);
            if (remainder.isEmpty()) {
                return FluidStack.EMPTY;
            }
            toInsert = remainder;
        }
        return toInsert;
    }

    public static FluidStack extract(int amount, InteractionType action, IntSupplier tankCount, Int2ObjectFunction<FluidStack> inTankGetter, ExtractFluid extractFluid) {
        int tanks = tankCount.getAsInt();
        if (tanks == 1) {
            return extractFluid.extract(0, amount, action);
        }
        FluidStack extracted = FluidStack.EMPTY;
        int toDrain = amount;
        for (int tank = 0; tank < tanks; ++tank) {
            FluidStack drained;
            if (!extracted.isEmpty() && !FluidStack.isSameFluidSameComponents((FluidStack)extracted, (FluidStack)((FluidStack)inTankGetter.get(tank))) || (drained = extractFluid.extract(tank, toDrain, action)).isEmpty()) continue;
            if (extracted.isEmpty()) {
                extracted = drained;
            } else {
                extracted.grow(drained.getAmount());
            }
            if ((toDrain -= drained.getAmount()) == 0) break;
        }
        return extracted;
    }

    public static FluidStack extract(FluidStack stack, InteractionType action, IntSupplier tankCount, Int2ObjectFunction<FluidStack> inTankGetter, ExtractFluid extractFluid) {
        int tanks = tankCount.getAsInt();
        if (tanks == 1) {
            FluidStack inTank = (FluidStack)inTankGetter.get(0);
            if (inTank.isEmpty() || !FluidStack.isSameFluidSameComponents((FluidStack)inTank, (FluidStack)stack)) {
                return FluidStack.EMPTY;
            }
            return extractFluid.extract(0, stack.getAmount(), action);
        }
        FluidStack extracted = FluidStack.EMPTY;
        int toDrain = stack.getAmount();
        for (int tank = 0; tank < tanks; ++tank) {
            FluidStack drained;
            if (!FluidStack.isSameFluidSameComponents((FluidStack)stack, (FluidStack)((FluidStack)inTankGetter.get(tank))) || (drained = extractFluid.extract(tank, toDrain, action)).isEmpty()) continue;
            if (extracted.isEmpty()) {
                extracted = drained;
            } else {
                extracted.grow(drained.getAmount());
            }
            if ((toDrain -= drained.getAmount()) == 0) break;
        }
        return extracted;
    }

    @FunctionalInterface
    public static interface InsertFluid {
        public FluidStack insert(int var1, FluidStack var2, InteractionType var3);
    }

    @FunctionalInterface
    public static interface ExtractFluid {
        public FluidStack extract(int var1, int var2, InteractionType var3);
    }
}

