/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivetrees.util;

import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import cy.jdkdigital.productivelib.util.ColorUtil;
import cy.jdkdigital.productivetrees.ProductiveTrees;
import cy.jdkdigital.productivetrees.registry.TreeObject;
import cy.jdkdigital.productivetrees.registry.TreeRegistrator;
import net.minecraft.resources.ResourceLocation;

public class TreeCreator {
    public static TreeObject create(ResourceLocation id, JsonObject json) throws JsonSyntaxException {
        DataResult treeOptional = TreeObject.codec(id).parse((DynamicOps)JsonOps.INSTANCE, (Object)json);
        if (treeOptional.result().isPresent()) {
            TreeObject treeObject = (TreeObject)treeOptional.result().get();
            ColorUtil.getCacheColor((String)treeObject.getLeafColor());
            ColorUtil.getCacheColor((String)treeObject.getLogColor());
            ColorUtil.getCacheColor((String)treeObject.getPlankColor());
            if (treeObject.hasFruit()) {
                ColorUtil.getCacheColor((String)treeObject.getFruit().ripeColor());
                ColorUtil.getCacheColor((String)treeObject.getFruit().unripeColor());
            }
            TreeRegistrator.registerTree(treeObject);
            return treeObject;
        }
        ProductiveTrees.LOGGER.info("failed to read tree configuration for " + String.valueOf(id) + " " + String.valueOf(treeOptional.error()));
        return null;
    }
}

