/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivetrees.inventory;

import cy.jdkdigital.productivelib.common.block.entity.ICapabilityBlockEntity;
import cy.jdkdigital.productivelib.common.block.entity.InventoryHandlerHelper;
import cy.jdkdigital.productivelib.container.AbstractContainer;
import cy.jdkdigital.productivelib.container.ManualSlotItemHandler;
import cy.jdkdigital.productivetrees.common.block.entity.StripperBlockEntity;
import cy.jdkdigital.productivetrees.registry.TreeRegistrator;
import java.util.Objects;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.items.IItemHandler;

public class StripperContainer
extends AbstractContainer<StripperBlockEntity> {
    public StripperContainer(int windowId, Inventory playerInventory, FriendlyByteBuf data) {
        this(windowId, playerInventory, StripperContainer.getTileEntity(playerInventory, data));
    }

    public StripperContainer(int windowId, Inventory playerInventory, StripperBlockEntity blockEntity) {
        super((MenuType)TreeRegistrator.STRIPPER_MENU.get(), (ICapabilityBlockEntity)blockEntity, windowId);
        this.addSlot((Slot)new ManualSlotItemHandler((InventoryHandlerHelper.BlockEntityItemStackHandler)((StripperBlockEntity)this.getBlockEntity()).getItemHandler(), StripperBlockEntity.SLOT_IN, 44, 25));
        this.addSlot((Slot)new ManualSlotItemHandler((InventoryHandlerHelper.BlockEntityItemStackHandler)((StripperBlockEntity)this.getBlockEntity()).getItemHandler(), StripperBlockEntity.SLOT_AXE, 44, 44));
        this.addSlot((Slot)new ManualSlotItemHandler((InventoryHandlerHelper.BlockEntityItemStackHandler)((StripperBlockEntity)this.getBlockEntity()).getItemHandler(), StripperBlockEntity.SLOT_OUT, 116, 25));
        this.addSlot((Slot)new ManualSlotItemHandler((InventoryHandlerHelper.BlockEntityItemStackHandler)((StripperBlockEntity)this.getBlockEntity()).getItemHandler(), StripperBlockEntity.SLOT_BARK, 116, 44));
        this.addSlotBox((IItemHandler)((StripperBlockEntity)this.getBlockEntity()).getUpgradeHandler(), 0, 178, 8, 1, 18, 4, 18);
        this.layoutPlayerInventorySlots(playerInventory, 0, 8, 84);
    }

    private static StripperBlockEntity getTileEntity(Inventory playerInventory, FriendlyByteBuf data) {
        Objects.requireNonNull(playerInventory, "playerInventory cannot be null!");
        Objects.requireNonNull(data, "data cannot be null!");
        BlockEntity tileAtPos = playerInventory.player.level().getBlockEntity(data.readBlockPos());
        if (tileAtPos instanceof StripperBlockEntity) {
            return (StripperBlockEntity)tileAtPos;
        }
        throw new IllegalStateException("Block entity is not correct! " + String.valueOf(tileAtPos));
    }
}

