/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivetrees.inventory;

import cy.jdkdigital.productivelib.common.block.entity.ICapabilityBlockEntity;
import cy.jdkdigital.productivelib.common.block.entity.InventoryHandlerHelper;
import cy.jdkdigital.productivelib.container.AbstractContainer;
import cy.jdkdigital.productivelib.container.ManualSlotItemHandler;
import cy.jdkdigital.productivetrees.common.block.entity.SawmillBlockEntity;
import cy.jdkdigital.productivetrees.registry.TreeRegistrator;
import java.util.Objects;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.items.IItemHandler;

public class SawmillContainer
extends AbstractContainer<SawmillBlockEntity> {
    public SawmillContainer(int windowId, Inventory playerInventory, FriendlyByteBuf data) {
        this(windowId, playerInventory, SawmillContainer.getTileEntity(playerInventory, data));
    }

    public SawmillContainer(int windowId, Inventory playerInventory, final SawmillBlockEntity blockEntity) {
        super((MenuType)TreeRegistrator.SAWMILL_MENU.get(), (ICapabilityBlockEntity)blockEntity, windowId);
        this.addDataSlot(new DataSlot(this){

            public int get() {
                return blockEntity.progress;
            }

            public void set(int value) {
                blockEntity.progress = value;
            }
        });
        this.addSlot((Slot)new ManualSlotItemHandler((InventoryHandlerHelper.BlockEntityItemStackHandler)((SawmillBlockEntity)this.getBlockEntity()).getItemHandler(), SawmillBlockEntity.SLOT_IN, 44, 34));
        this.addSlot((Slot)new ManualSlotItemHandler((InventoryHandlerHelper.BlockEntityItemStackHandler)((SawmillBlockEntity)this.getBlockEntity()).getItemHandler(), SawmillBlockEntity.SLOT_OUT, 116, 25));
        this.addSlot((Slot)new ManualSlotItemHandler((InventoryHandlerHelper.BlockEntityItemStackHandler)((SawmillBlockEntity)this.getBlockEntity()).getItemHandler(), SawmillBlockEntity.SLOT_SECONDARY, 107, 43));
        this.addSlot((Slot)new ManualSlotItemHandler((InventoryHandlerHelper.BlockEntityItemStackHandler)((SawmillBlockEntity)this.getBlockEntity()).getItemHandler(), SawmillBlockEntity.SLOT_TERTIARY, 125, 43));
        this.addSlotBox((IItemHandler)((SawmillBlockEntity)this.getBlockEntity()).getUpgradeHandler(), 0, 178, 8, 1, 18, 4, 18);
        this.layoutPlayerInventorySlots(playerInventory, 0, 8, 84);
    }

    private static SawmillBlockEntity getTileEntity(Inventory playerInventory, FriendlyByteBuf data) {
        Objects.requireNonNull(playerInventory, "playerInventory cannot be null!");
        Objects.requireNonNull(data, "data cannot be null!");
        BlockEntity tileAtPos = playerInventory.player.level().getBlockEntity(data.readBlockPos());
        if (tileAtPos instanceof SawmillBlockEntity) {
            return (SawmillBlockEntity)tileAtPos;
        }
        throw new IllegalStateException("Block entity is not correct! " + String.valueOf(tileAtPos));
    }
}

