/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivetrees.feature.foliageplacers;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import cy.jdkdigital.productivetrees.registry.TreeRegistrator;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.BlobFoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacerType;

public class TaperedFoliagePlacer
extends BlobFoliagePlacer {
    public static final MapCodec<TaperedFoliagePlacer> CODEC = RecordCodecBuilder.mapCodec(instance -> TaperedFoliagePlacer.blobParts((RecordCodecBuilder.Instance)instance).apply((Applicative)instance, TaperedFoliagePlacer::new));

    public TaperedFoliagePlacer(IntProvider radius, IntProvider offset, int height) {
        super(radius, offset, height);
    }

    protected FoliagePlacerType<?> type() {
        return (FoliagePlacerType)TreeRegistrator.TAPERED_FOLIAGE_PLACER.get();
    }

    protected void createFoliage(LevelSimulatedReader level, FoliagePlacer.FoliageSetter foliageSetter, RandomSource randomSource, TreeConfiguration treeConfiguration, int pMaxFreeTreeHeight, FoliagePlacer.FoliageAttachment pAttachment, int pFoliageHeight, int pFoliageRadius, int pOffset) {
        for (int i = pOffset; i >= pOffset - pFoliageHeight; --i) {
            int j = pFoliageRadius + pAttachment.radiusOffset() - 1 - i;
            this.placeLeavesRow(level, foliageSetter, randomSource, treeConfiguration, pAttachment.pos(), j, i, pAttachment.doubleTrunk());
        }
    }

    protected boolean shouldSkipLocation(RandomSource randomSource, int pLocalX, int pLocalY, int pLocalZ, int pRange, boolean pLarge) {
        return pLocalX == pRange && pLocalZ == pRange && randomSource.nextInt(2) == 0;
    }
}

