/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivetrees.event;

import cy.jdkdigital.productivelib.event.BeeReleaseEvent;
import cy.jdkdigital.productivelib.event.CollectValidUpgradesEvent;
import cy.jdkdigital.productivelib.event.UpgradeTooltipEvent;
import cy.jdkdigital.productivelib.registry.LibItems;
import cy.jdkdigital.productivetrees.ProductiveTrees;
import cy.jdkdigital.productivetrees.common.block.ProductiveLogBlock;
import cy.jdkdigital.productivetrees.common.block.ProductiveSaplingBlock;
import cy.jdkdigital.productivetrees.common.block.entity.PollinatedLeavesBlockEntity;
import cy.jdkdigital.productivetrees.integrations.productivebees.CompatHandler;
import cy.jdkdigital.productivetrees.registry.TreeFinder;
import cy.jdkdigital.productivetrees.registry.TreeObject;
import cy.jdkdigital.productivetrees.registry.TreeRegistrator;
import cy.jdkdigital.productivetrees.util.TreeUtil;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BeehiveBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.event.AddPackFindersEvent;
import net.neoforged.neoforge.event.AddReloadListenerEvent;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.event.level.BlockGrowFeatureEvent;
import net.neoforged.neoforge.registries.DeferredHolder;

@EventBusSubscriber(modid="productivetrees")
public class EventHandler {
    @SubscribeEvent
    public static void onServerStarting(AddReloadListenerEvent event) {
        TreeFinder.context = event.getConditionContext();
    }

    @SubscribeEvent
    public static void collectValidUpgrades(CollectValidUpgradesEvent event) {
        if (ModList.get().isLoaded("productivebees")) {
            CompatHandler.collectValidUpgrades(event);
        }
    }

    @SubscribeEvent
    public static void addUpgradeTooltip(UpgradeTooltipEvent event) {
        ResourceLocation upgradeType = BuiltInRegistries.ITEM.getKey((Object)event.getStack().getItem());
        String tPrefix = "productivetrees.information.upgrade." + upgradeType.getPath() + ".";
        switch (upgradeType.getPath()) {
            case "upgrade_time": 
            case "upgrade_time_2": {
                event.addValidBlock((Component)Component.translatable((String)"productivetrees.devices.stripper"), tPrefix + "stripper");
                event.addValidBlock((Component)Component.translatable((String)"productivetrees.devices.sawmill"), tPrefix + "sawmill");
                event.addValidBlock((Component)Component.translatable((String)"productivetrees.devices.pollen_sifter"), tPrefix + "pollen_sifter");
                break;
            }
            case "upgrade_pollen_sieve": {
                event.addValidBlock((Component)Component.translatable((String)"productivetrees.devices.advanced_beehive"), tPrefix + "advanced_beehive");
            }
        }
    }

    @SubscribeEvent
    public static void blockBreak(BlockEvent.BreakEvent event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof Level) {
            PollinatedLeavesBlockEntity pollinatedLeavesBlockEntity;
            Level level = (Level)levelAccessor;
            if (event.getState().is((Block)TreeRegistrator.POLLINATED_LEAVES.get()) && (levelAccessor = level.getBlockEntity(event.getPos())) instanceof PollinatedLeavesBlockEntity && !(pollinatedLeavesBlockEntity = (PollinatedLeavesBlockEntity)levelAccessor).getResult().isEmpty()) {
                Block.popResource((Level)level, (BlockPos)event.getPos(), (ItemStack)pollinatedLeavesBlockEntity.getResult().copy());
            }
        }
    }

    @SubscribeEvent
    public static void blockToolModified(BlockEvent.BlockToolModificationEvent event) {
        LevelAccessor levelAccessor;
        if (!event.isSimulated() && event.getItemAbility().equals(ItemAbilities.AXE_STRIP) && (levelAccessor = event.getLevel()) instanceof ServerLevel) {
            ProductiveLogBlock logBlock;
            TreeObject tree;
            ServerLevel level = (ServerLevel)levelAccessor;
            Block block = event.getLevel().getBlockState(event.getPos()).getBlock();
            if (block instanceof ProductiveLogBlock && (tree = TreeUtil.getTree((Block)(logBlock = (ProductiveLogBlock)block))) != null && tree.getStripDrop().isPresent()) {
                Block.popResource((Level)level, (BlockPos)event.getPos(), (ItemStack)tree.getStripDropStack().copy());
            }
        }
    }

    @SubscribeEvent
    public static void beeRelease(BeeReleaseEvent event) {
        if (ModList.get().isLoaded("productivebees")) {
            CompatHandler.beeRelease(event);
        } else {
            Level level = event.getLevel();
            if (level instanceof ServerLevel) {
                ServerLevel level2 = (ServerLevel)level;
                if (event.getBeeState().equals((Object)BeehiveBlockEntity.BeeReleaseStatus.HONEY_DELIVERED) && event.getBlockEntity() instanceof BeehiveBlockEntity && event.getBee().getHivePos() != null) {
                    TreeUtil.pollinateLeaves((Level)level2, event.getBee().getHivePos(), 4, false, new ArrayList<BlockState>());
                }
            }
        }
    }

    @SubscribeEvent
    public static void onBlockGrow(BlockGrowFeatureEvent event) {
        ProductiveSaplingBlock saplingBlock;
        ServerLevel serverLevel;
        Block grownBlock;
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof ServerLevel && (grownBlock = (serverLevel = (ServerLevel)levelAccessor).getBlockState(event.getPos()).getBlock()) instanceof ProductiveSaplingBlock && !(saplingBlock = (ProductiveSaplingBlock)grownBlock).getTree().getMutationInfo().target().equals((Object)ProductiveTrees.EMPTY_RL) && saplingBlock.getTree().getMutationInfo().chance() >= event.getRandom().nextFloat()) {
            event.setFeature(ResourceKey.create((ResourceKey)Registries.CONFIGURED_FEATURE, (ResourceLocation)saplingBlock.getTree().getMutationInfo().target()));
        }
    }

    @SubscribeEvent
    public static void buildContents(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey().equals(TreeRegistrator.TAB_KEY)) {
            boolean hasBees = ModList.get().isLoaded("productivebees");
            for (DeferredHolder item : ProductiveTrees.ITEMS.getEntries()) {
                if (item.getId().getPath().equals("pollen_sifter") && hasBees || item.getId().getPath().equals("upgrade_pollen_sieve") && !hasBees) continue;
                event.accept((ItemLike)item.get());
            }
            event.accept((ItemLike)LibItems.UPGRADE_POLLEN_SIEVE.get());
            event.accept((ItemLike)LibItems.UPGRADE_TIME.get());
            event.accept((ItemLike)LibItems.UPGRADE_TIME_2.get());
        }
    }

    @SubscribeEvent
    public static void dynamicDatapack(AddPackFindersEvent event) {
    }

    @SubscribeEvent
    public static void registerBlockEntityCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)TreeRegistrator.STRIPPER_BLOCK_ENTITY.get(), (myBlockEntity, side) -> myBlockEntity.inventoryHandler);
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)TreeRegistrator.SAWMILL_BLOCK_ENTITY.get(), (myBlockEntity, side) -> myBlockEntity.inventoryHandler);
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)TreeRegistrator.WOOD_WORKER_BLOCK_ENTITY.get(), (myBlockEntity, side) -> myBlockEntity.inventoryHandler);
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)TreeRegistrator.POLLEN_SIFTER_BLOCK_ENTITY.get(), (myBlockEntity, side) -> myBlockEntity.inventoryHandler);
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)TreeRegistrator.TIME_TRAVELLER_DISPLAY_BLOCK_ENTITY.get(), (myBlockEntity, side) -> myBlockEntity.inventoryHandler);
    }
}

