/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivetrees.common.feature;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import cy.jdkdigital.productivetrees.registry.TreeRegistrator;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;
import org.jetbrains.annotations.NotNull;

public class TrunkVineDecorator
extends TreeDecorator {
    public static final MapCodec<TrunkVineDecorator> CODEC = RecordCodecBuilder.mapCodec(decoratorInstance -> decoratorInstance.group((App)BlockStateProvider.CODEC.fieldOf("vine_provider").forGetter(TrunkVineDecorator::getVineProvider)).apply((Applicative)decoratorInstance, TrunkVineDecorator::new));
    public final BlockStateProvider vineProvider;

    public TrunkVineDecorator(BlockStateProvider vineProvider) {
        this.vineProvider = vineProvider;
    }

    @NotNull
    protected TreeDecoratorType<?> type() {
        return (TreeDecoratorType)TreeRegistrator.TRUNK_VINE.get();
    }

    public BlockStateProvider getVineProvider() {
        return this.vineProvider;
    }

    public void place(TreeDecorator.Context context) {
        RandomSource randomsource = context.random();
        context.logs().forEach(logPos -> {
            BlockPos blockpos;
            if (randomsource.nextInt(3) > 0 && context.isAir(blockpos = logPos.west())) {
                context.setBlock(blockpos, (BlockState)this.vineProvider.getState(randomsource, blockpos).setValue((Property)VineBlock.EAST, (Comparable)Boolean.valueOf(true)));
            }
            if (randomsource.nextInt(3) > 0 && context.isAir(blockpos = logPos.east())) {
                context.setBlock(blockpos, (BlockState)this.vineProvider.getState(randomsource, blockpos).setValue((Property)VineBlock.WEST, (Comparable)Boolean.valueOf(true)));
            }
            if (randomsource.nextInt(3) > 0 && context.isAir(blockpos = logPos.north())) {
                context.setBlock(blockpos, (BlockState)this.vineProvider.getState(randomsource, blockpos).setValue((Property)VineBlock.SOUTH, (Comparable)Boolean.valueOf(true)));
            }
            if (randomsource.nextInt(3) > 0 && context.isAir(blockpos = logPos.south())) {
                context.setBlock(blockpos, (BlockState)this.vineProvider.getState(randomsource, blockpos).setValue((Property)VineBlock.NORTH, (Comparable)Boolean.valueOf(true)));
            }
        });
    }
}

