/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivetrees.common.feature;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import cy.jdkdigital.productivetrees.registry.TreeRegistrator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;

public class EntityPlacerDecorator
extends TreeDecorator {
    public static final MapCodec<EntityPlacerDecorator> CODEC = RecordCodecBuilder.mapCodec(decoratorInstance -> decoratorInstance.group((App)ResourceLocation.CODEC.fieldOf("entity").forGetter(EntityPlacerDecorator::getEntity), (App)Codec.INT.fieldOf("count").orElse((Object)1).forGetter(EntityPlacerDecorator::getCount)).apply((Applicative)decoratorInstance, EntityPlacerDecorator::new));
    private final ResourceLocation entity;
    private final int count;

    public EntityPlacerDecorator(ResourceLocation entity, int count) {
        this.entity = entity;
        this.count = count;
    }

    protected TreeDecoratorType<?> type() {
        return (TreeDecoratorType)TreeRegistrator.ENTITY_PLACER.get();
    }

    public void place(TreeDecorator.Context context) {
        if (context.logs().isEmpty()) {
            return;
        }
        block0: for (int i = 0; i < this.count; ++i) {
            BlockPos pos = (BlockPos)context.logs().get(context.random().nextInt(context.logs().size()));
            for (Direction dir : Direction.values()) {
                if (!context.isAir(pos.relative(dir))) continue;
                context.setBlock(pos.relative(dir), ((Block)TreeRegistrator.ENTITY_SPAWNER.get()).defaultBlockState());
                continue block0;
            }
        }
    }

    public ResourceLocation getEntity() {
        return this.entity;
    }

    public int getCount() {
        return this.count;
    }
}

