/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.stack.serializer;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.stack.ListEmiIngredient;
import dev.emi.emi.api.stack.serializer.EmiIngredientSerializer;
import dev.emi.emi.registry.EmiIngredientSerializers;
import java.util.ArrayList;
import net.minecraft.util.GsonHelper;

public class ListEmiIngredientSerializer
implements EmiIngredientSerializer<ListEmiIngredient> {
    @Override
    public String getType() {
        return "list";
    }

    @Override
    public EmiIngredient deserialize(JsonElement element) {
        JsonArray ingredientsArray;
        float chance;
        long amount;
        if (element.isJsonObject()) {
            JsonObject json = element.getAsJsonObject();
            amount = GsonHelper.getAsLong((JsonObject)json, (String)"amount", (long)1L);
            chance = GsonHelper.getAsFloat((JsonObject)json, (String)"chance", (float)1.0f);
            ingredientsArray = GsonHelper.getAsJsonArray((JsonObject)json, (String)"ingredients");
        } else if (element.isJsonArray()) {
            ingredientsArray = element.getAsJsonArray();
            amount = 1L;
            chance = 1.0f;
        } else {
            return EmiStack.EMPTY;
        }
        ArrayList<EmiIngredient> ingredients = new ArrayList<EmiIngredient>();
        for (JsonElement ingredientElement : ingredientsArray) {
            ingredients.add(EmiIngredientSerializers.deserialize(ingredientElement));
        }
        EmiIngredient ingredient = EmiIngredient.of(ingredients, amount);
        if (chance != 1.0f) {
            ingredient.setChance(chance);
        }
        return ingredient;
    }

    @Override
    public JsonElement serialize(ListEmiIngredient stack) {
        if (stack.getAmount() == 1L && stack.getChance() == 1.0f) {
            JsonArray array = new JsonArray();
            for (EmiIngredient emiIngredient : stack.getIngredients()) {
                array.add(EmiIngredientSerializers.serialize(emiIngredient));
            }
            return array;
        }
        JsonObject json = new JsonObject();
        json.addProperty("type", this.getType());
        if (stack.getAmount() != 1L) {
            json.addProperty("amount", (Number)stack.getAmount());
        }
        if (stack.getChance() != 1.0f) {
            json.addProperty("chance", (Number)Float.valueOf(stack.getChance()));
        }
        JsonArray ingredients = new JsonArray();
        for (EmiIngredient emiIngredient : stack.getIngredients()) {
            ingredients.add(EmiIngredientSerializers.serialize(emiIngredient));
        }
        json.add("ingredients", (JsonElement)ingredients);
        return json;
    }
}

