/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.sushigocrafting.recipe;

import com.buuz135.sushigocrafting.item.AmountItem;
import com.buuz135.sushigocrafting.item.SushiDataComponent;
import com.buuz135.sushigocrafting.proxy.SushiContent;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class CombineAmountItemRecipe
extends CustomRecipe {
    public CombineAmountItemRecipe() {
        super(CraftingBookCategory.MISC);
    }

    public static boolean stackMatches(ItemStack first, ItemStack second) {
        return first.getItem() == second.getItem() && first.getCount() == 1 && second.getCount() == 1 && first.getItem() instanceof AmountItem && ((AmountItem)first.getItem()).getCurrentAmount(first) + ((AmountItem)second.getItem()).getCurrentAmount(second) <= ((AmountItem)first.getItem()).getMaxCombineAmount();
    }

    public static boolean matches(List<ItemStack> list) {
        return list.size() == 2;
    }

    public static ItemStack getResult(List<ItemStack> list) {
        if (list.size() == 2) {
            ItemStack first = list.get(0);
            ItemStack second = list.get(1);
            if (first.getItem() == second.getItem() && first.getCount() == 1 && second.getCount() == 1 && first.getItem() instanceof AmountItem) {
                ItemStack output = new ItemStack((ItemLike)first.getItem());
                output.set(SushiDataComponent.AMOUNT, (Object)Math.min(((AmountItem)first.getItem()).getMaxCombineAmount(), ((AmountItem)first.getItem()).getCurrentAmount(first) + ((AmountItem)second.getItem()).getCurrentAmount(second)));
                return output;
            }
        }
        return ItemStack.EMPTY;
    }

    public boolean matches(CraftingInput inv, Level worldIn) {
        ArrayList list = Lists.newArrayList();
        for (int i = 0; i < inv.size(); ++i) {
            ItemStack itemstack1;
            ItemStack itemstack = inv.getItem(i);
            if (itemstack.isEmpty()) continue;
            list.add(itemstack);
            if (list.size() <= 1 || CombineAmountItemRecipe.stackMatches(itemstack, itemstack1 = (ItemStack)list.get(0))) continue;
            return false;
        }
        return CombineAmountItemRecipe.matches(list);
    }

    public ItemStack assemble(CraftingInput inv, HolderLookup.Provider provider) {
        ArrayList list = Lists.newArrayList();
        for (int i = 0; i < inv.size(); ++i) {
            ItemStack itemstack1;
            ItemStack itemstack = inv.getItem(i);
            if (itemstack.isEmpty()) continue;
            list.add(itemstack);
            if (list.size() <= 1 || CombineAmountItemRecipe.stackMatches(itemstack, itemstack1 = (ItemStack)list.get(0))) continue;
            return ItemStack.EMPTY;
        }
        return CombineAmountItemRecipe.getResult(list);
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width * height >= 2;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)SushiContent.RecipeSerializers.COMBINE_AMOUNT.get();
    }
}

