/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.sushigocrafting.datagen;

import com.buuz135.sushigocrafting.api.IFoodIngredient;
import com.buuz135.sushigocrafting.api.impl.FoodAPI;
import com.buuz135.sushigocrafting.api.impl.FoodIngredient;
import com.buuz135.sushigocrafting.proxy.SushiContent;
import com.buuz135.sushigocrafting.recipe.CuttingBoardRecipe;
import com.buuz135.sushigocrafting.recipe.FermentingBarrelRecipe;
import com.hrznstudio.titanium.recipe.generator.TitaniumShapedRecipeBuilder;
import com.hrznstudio.titanium.recipe.generator.TitaniumShapelessRecipeBuilder;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.fluids.FluidStack;

public class SushiRecipeProvider
extends RecipeProvider {
    public SushiRecipeProvider(DataGenerator generatorIn, CompletableFuture<HolderLookup.Provider> lookupProvider) {
        super(generatorIn.getPackOutput(), lookupProvider);
    }

    public void buildRecipes(RecipeOutput consumer) {
        TitaniumShapedRecipeBuilder.shapedRecipe((ItemLike)((ItemLike)SushiContent.Items.KNIFE_CLEAVER.get())).pattern(" II").pattern("II ").pattern("S  ").define(Character.valueOf('I'), Tags.Items.INGOTS_IRON).define(Character.valueOf('S'), (ItemLike)Items.STICK).save(consumer);
        TitaniumShapedRecipeBuilder.shapedRecipe((ItemLike)((ItemLike)SushiContent.Items.ROLLER.get())).pattern("BBB").pattern("SSS").pattern("BBB").define(Character.valueOf('B'), (ItemLike)Items.BAMBOO).define(Character.valueOf('S'), (ItemLike)Items.STRING).save(consumer);
        TitaniumShapedRecipeBuilder.shapedRecipe((ItemLike)((ItemLike)SushiContent.Items.RICE_COOKER.get())).pattern("IGI").pattern("IFI").pattern("IRI").define(Character.valueOf('I'), Tags.Items.INGOTS_IRON).define(Character.valueOf('G'), (ItemLike)Items.LIGHT_WEIGHTED_PRESSURE_PLATE).define(Character.valueOf('F'), (ItemLike)Items.FURNACE).define(Character.valueOf('R'), (ItemLike)Items.REDSTONE).save(consumer);
        TitaniumShapedRecipeBuilder.shapedRecipe((ItemLike)((ItemLike)SushiContent.Items.COOLER_BOX.get())).pattern("IGI").pattern("IFI").pattern("III").define(Character.valueOf('I'), (ItemLike)Blocks.SNOW_BLOCK).define(Character.valueOf('G'), (ItemLike)Blocks.IRON_TRAPDOOR).define(Character.valueOf('F'), Tags.Items.CHESTS).save(consumer);
        TitaniumShapedRecipeBuilder.shapedRecipe((ItemLike)((ItemLike)SushiContent.Items.FERMENTATION_BARREL.get())).pattern("IGI").pattern("IFI").pattern("III").define(Character.valueOf('I'), ItemTags.PLANKS).define(Character.valueOf('G'), ItemTags.WOODEN_PRESSURE_PLATES).define(Character.valueOf('F'), (ItemLike)Blocks.FURNACE).save(consumer);
        TitaniumShapedRecipeBuilder.shapedRecipe((ItemLike)((ItemLike)SushiContent.Items.CUTTING_BOARD.get())).pattern("   ").pattern("SSS").pattern("BBB").define(Character.valueOf('S'), ItemTags.SLABS).define(Character.valueOf('B'), ItemTags.LOGS).save(consumer);
        TitaniumShapelessRecipeBuilder.shapelessRecipe((ItemLike)((ItemLike)SushiContent.Items.SEAWEED_ON_A_STICK.get())).requires((ItemLike)Items.FISHING_ROD).requires((ItemLike)Items.KELP).save(consumer);
        for (IFoodIngredient value : FoodAPI.get().getFoodIngredient()) {
            if (!(value instanceof FoodIngredient) || !((FoodIngredient)value).needsChoppingRecipe()) continue;
            CuttingBoardRecipe recipe = new CuttingBoardRecipe(((FoodIngredient)value).getInput().get(), value.getName());
            recipe.save(consumer, ResourceLocation.fromNamespaceAndPath((String)"sushigocrafting", (String)("cutting_board/" + value.getName())));
        }
        new FermentingBarrelRecipe(Ingredient.EMPTY, new FluidStack((Fluid)NeoForgeMod.MILK.get(), 250), new ItemStack((ItemLike)SushiContent.Items.CHEESE.get())).save(consumer, ResourceLocation.fromNamespaceAndPath((String)"sushigocrafting", (String)"fermenting_barrel/cheese"));
        new FermentingBarrelRecipe(Ingredient.of((TagKey)ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"crops/soybean"))), new FluidStack((Fluid)Fluids.WATER, 250), new ItemStack((ItemLike)SushiContent.Items.SOY_SAUCE.get())).save(consumer, ResourceLocation.fromNamespaceAndPath((String)"sushigocrafting", (String)"fermenting_barrel/soy"));
    }
}

