/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.sushigocrafting.client.entity.model;

import com.buuz135.sushigocrafting.entity.ShrimpEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class ShrimpModel
extends HierarchicalModel<ShrimpEntity> {
    private final ModelPart body1;
    private final ModelPart body2;
    private final ModelPart body3;
    private final ModelPart body4;
    private final ModelPart root;

    public ShrimpModel(ModelPart root) {
        this.root = root;
        this.body1 = root.getChild("body1");
        this.body2 = root.getChild("body2");
        this.body3 = root.getChild("body3");
        this.body4 = root.getChild("body4");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        int i = 22;
        partdefinition.addOrReplaceChild("body1", CubeListBuilder.create().texOffs(0, 0).addBox(-1.5f, 0.0f, 1.0f, 3.0f, 2.0f, 2.0f).texOffs(21, 5).addBox(-1.5f, 2.0f, 1.0f, 3.0f, 1.0f, 2.0f).texOffs(20, 0).addBox(-1.5f, 1.0f, -2.0f, 3.0f, 2.0f, 3.0f), PartPose.offset((float)0.0f, (float)22.0f, (float)-3.5f));
        partdefinition.addOrReplaceChild("body2", CubeListBuilder.create().texOffs(0, 4).addBox(-1.5f, 1.0f, 1.0f, 3.0f, 2.0f, 2.0f).texOffs(21, 8).addBox(-1.5f, 3.0f, 1.0f, 3.0f, 1.0f, 2.0f), PartPose.offset((float)0.0f, (float)21.0f, (float)-1.5f));
        partdefinition.addOrReplaceChild("body3", CubeListBuilder.create().texOffs(0, 8).addBox(-1.0f, 0.0f, -5.5f, 2.0f, 2.0f, 3.0f).texOffs(21, 11).addBox(-1.0f, 2.0f, -5.5f, 2.0f, 1.0f, 3.0f), PartPose.offset((float)0.0f, (float)22.0f, (float)7.0f));
        partdefinition.addOrReplaceChild("body4", CubeListBuilder.create().texOffs(1, 13).addBox(-1.0f, 0.0f, 0.0f, 2.0f, 1.0f, 2.0f).texOffs(21, 15).addBox(-1.5f, 1.0f, 2.0f, 3.0f, 0.0f, 2.0f), PartPose.offset((float)0.0f, (float)23.0f, (float)4.5f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)32, (int)32);
    }

    public void setupAnim(ShrimpEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float f = Mth.sin((float)(0.3f * ageInTicks));
        this.body1.yRot = f * 0.015f;
        this.body4.xRot = f * 0.2f;
    }

    public void renderToBuffer(PoseStack matrixStack, VertexConsumer buffer, int packedLight, int packedOverlay, int color) {
        this.body1.render(matrixStack, buffer, packedLight, packedOverlay);
        this.body2.render(matrixStack, buffer, packedLight, packedOverlay);
        this.body3.render(matrixStack, buffer, packedLight, packedOverlay);
        this.body4.render(matrixStack, buffer, packedLight, packedOverlay);
    }

    public ModelPart root() {
        return this.root;
    }

    public void setRotationAngle(ModelPart modelRenderer, float x, float y, float z) {
        modelRenderer.xRot = x;
        modelRenderer.yRot = y;
        modelRenderer.zRot = z;
    }
}

