/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.sushigocrafting.api.impl.renderer;

import com.buuz135.sushigocrafting.api.IFoodIngredientRenderer;
import com.buuz135.sushigocrafting.item.AmountItem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Axis;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class StackFoodIngredientRenderer
implements IFoodIngredientRenderer {
    private final Supplier<AmountItem> itemStack;
    private final float x;
    private final float y;
    private final float z;
    private final float rotationY;
    private final float rotationZ;
    private ItemStack itemStackCache;

    public StackFoodIngredientRenderer(Supplier<AmountItem> stack, float x, float y, float z, float rotationY, float rotationZ) {
        this.itemStack = stack;
        this.x = x;
        this.y = y;
        this.z = z;
        this.rotationY = rotationY;
        this.rotationZ = rotationZ;
    }

    @Override
    public Pair<Float, Float> render(PoseStack stack, MultiBufferSource renderTypeBuffer, int weight, int combinedLightIn, int combinedOverlayIn) {
        if (this.itemStackCache == null) {
            this.itemStackCache = new ItemStack((ItemLike)this.itemStack.get());
        }
        stack.pushPose();
        stack.translate(this.x, this.y, this.z);
        stack.mulPose(Axis.XP.rotationDegrees(90.0f));
        stack.mulPose(Axis.YP.rotationDegrees(this.rotationY));
        stack.mulPose(Axis.ZP.rotationDegrees(this.rotationZ));
        stack.scale(0.5f, 0.5f, 0.5f);
        Minecraft.getInstance().getItemRenderer().renderStatic(this.itemStackCache, ItemDisplayContext.GROUND, combinedLightIn, combinedOverlayIn, stack, renderTypeBuffer, (Level)Minecraft.getInstance().level, 0);
        stack.popPose();
        return Pair.of((Object)Float.valueOf(0.0f), (Object)Float.valueOf(0.0f));
    }
}

