/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.entangled;

import com.supermartijn642.core.CommonUtils;
import com.supermartijn642.core.block.BaseBlockEntityType;
import com.supermartijn642.core.item.BaseBlockItem;
import com.supermartijn642.core.item.CreativeItemGroup;
import com.supermartijn642.core.item.ItemProperties;
import com.supermartijn642.core.registry.GeneratorRegistrationHandler;
import com.supermartijn642.core.registry.RegistrationHandler;
import com.supermartijn642.core.registry.RegistryEntryAcceptor;
import com.supermartijn642.entangled.EntangledBinderItem;
import com.supermartijn642.entangled.EntangledBlock;
import com.supermartijn642.entangled.EntangledBlockEntity;
import com.supermartijn642.entangled.EntangledClient;
import com.supermartijn642.entangled.EntangledConfig;
import com.supermartijn642.entangled.generators.EntangledAtlasSourceGenerator;
import com.supermartijn642.entangled.generators.EntangledBlockStateGenerator;
import com.supermartijn642.entangled.generators.EntangledLanguageGenerator;
import com.supermartijn642.entangled.generators.EntangledLootTableGenerator;
import com.supermartijn642.entangled.generators.EntangledModelGenerator;
import com.supermartijn642.entangled.generators.EntangledRecipeGenerator;
import com.supermartijn642.entangled.generators.EntangledTagGenerator;
import com.supermartijn642.entangled.integration.TheOneProbePlugin;
import net.minecraft.world.level.block.Block;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.common.Mod;
import org.slf4j.Logger;

@Mod(value="entangled")
public class Entangled {
    public static final Logger LOGGER = CommonUtils.getLogger((String)"entangled");
    @RegistryEntryAcceptor(namespace="entangled", identifier="block", registry=RegistryEntryAcceptor.Registry.BLOCKS)
    public static EntangledBlock block;
    @RegistryEntryAcceptor(namespace="entangled", identifier="tile", registry=RegistryEntryAcceptor.Registry.BLOCK_ENTITY_TYPES)
    public static BaseBlockEntityType<EntangledBlockEntity> tile;
    @RegistryEntryAcceptor(namespace="entangled", identifier="item", registry=RegistryEntryAcceptor.Registry.ITEMS)
    public static EntangledBinderItem item;

    public Entangled(IEventBus eventBus) {
        eventBus.addListener(TheOneProbePlugin::interModEnqueue);
        Entangled.register();
        if (CommonUtils.getEnvironmentSide().isClient()) {
            EntangledClient.register();
        }
        Entangled.registerGenerators();
        EntangledConfig.init();
    }

    private static void register() {
        RegistrationHandler handler = RegistrationHandler.get((String)"entangled");
        handler.registerBlock("block", EntangledBlock::new);
        handler.registerItem("block", () -> new BaseBlockItem((Block)block, ItemProperties.create().group(CreativeItemGroup.getFunctionalBlocks())));
        handler.registerBlockEntityType("tile", () -> BaseBlockEntityType.create(EntangledBlockEntity::new, (Block[])new Block[]{block}));
        handler.registerItem("item", EntangledBinderItem::new);
        handler.registerDataComponentType("binder_target", EntangledBinderItem.BINDER_TARGET);
    }

    private static void registerGenerators() {
        GeneratorRegistrationHandler handler = GeneratorRegistrationHandler.get((String)"entangled");
        handler.addGenerator(EntangledAtlasSourceGenerator::new);
        handler.addGenerator(EntangledBlockStateGenerator::new);
        handler.addGenerator(EntangledModelGenerator::new);
        handler.addGenerator(EntangledLanguageGenerator::new);
        handler.addGenerator(EntangledLootTableGenerator::new);
        handler.addGenerator(EntangledRecipeGenerator::new);
        handler.addGenerator(EntangledTagGenerator::new);
    }
}

