/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.createcasing.kubejs.builders;

import com.google.common.base.Preconditions;
import dev.latvian.mods.kubejs.script.SourceLine;
import dev.latvian.mods.rhino.util.HideFromJS;
import fr.iglee42.createcasing.transmissions.TransmissionSet;
import java.util.function.Supplier;
import net.minecraft.world.item.Item;

public class TransmissionSetBuilder {
    private final String name;
    public SourceLine sourceLine;
    private TransmissionSet.Options options;

    public TransmissionSetBuilder(String name) {
        this.name = name;
        this.sourceLine = SourceLine.UNKNOWN;
        this.options = new TransmissionSet.Options().kjsGenerated();
    }

    @HideFromJS
    public String getName() {
        return this.name;
    }

    @HideFromJS
    public TransmissionSet.Options getOptions() {
        return this.options;
    }

    public TransmissionSetBuilder item(Supplier<? extends Item> item) {
        Preconditions.checkNotNull(item, (Object)"Item Supplier can't be null");
        this.options.item(item);
        return this;
    }

    public TransmissionSetBuilder shaft() {
        this.options.shaft();
        return this;
    }

    public TransmissionSetBuilder cogwheel() {
        this.options.cogwheel();
        return this;
    }

    public TransmissionSetBuilder largeCogwheel() {
        this.options.largeCogwheel();
        return this;
    }

    public TransmissionSetBuilder notEncasable() {
        this.options.notEncasable();
        return this;
    }

    public TransmissionSetBuilder everything(Supplier<? extends Item> item) {
        return this.item(item).shaft().cogwheel().largeCogwheel();
    }
}

