/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.createcasing.blocks.customs;

import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.chainDrive.ChainDriveBlock;
import fr.iglee42.createcasing.registries.EncasedBlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class CustomChainDriveBlock
extends ChainDriveBlock {
    private final String type;

    public CustomChainDriveBlock(BlockBehaviour.Properties properties, String type) {
        super(properties);
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public BlockState updateShape(BlockState stateIn, Direction face, BlockState neighbour, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        CustomChainDriveBlock b;
        Block block = neighbour.getBlock();
        if (block instanceof CustomChainDriveBlock && this.type.equals((b = (CustomChainDriveBlock)block).getType()) || neighbour.isAir()) {
            Direction.Axis otherConnectionAxis;
            boolean positive;
            ChainDriveBlock.Part part = (ChainDriveBlock.Part)stateIn.getValue(PART);
            Direction.Axis axis = (Direction.Axis)stateIn.getValue((Property)AXIS);
            boolean connectionAlongFirst = (Boolean)stateIn.getValue((Property)CONNECTED_ALONG_FIRST_COORDINATE);
            Direction.Axis connectionAxis = connectionAlongFirst ? (axis == Direction.Axis.X ? Direction.Axis.Y : Direction.Axis.X) : (axis == Direction.Axis.Z ? Direction.Axis.Y : Direction.Axis.Z);
            Direction.Axis faceAxis = face.getAxis();
            boolean facingAlongFirst = axis == Direction.Axis.X ? faceAxis.isVertical() : faceAxis == Direction.Axis.X;
            boolean bl = positive = face.getAxisDirection() == Direction.AxisDirection.POSITIVE;
            if (axis == faceAxis) {
                return stateIn;
            }
            if (!(neighbour.getBlock() instanceof CustomChainDriveBlock)) {
                if (facingAlongFirst != connectionAlongFirst || part == ChainDriveBlock.Part.NONE) {
                    return stateIn;
                }
                if (part == ChainDriveBlock.Part.MIDDLE) {
                    return (BlockState)stateIn.setValue(PART, (Comparable)(positive ? ChainDriveBlock.Part.END : ChainDriveBlock.Part.START));
                }
                if (part == ChainDriveBlock.Part.START == positive) {
                    return (BlockState)stateIn.setValue(PART, (Comparable)ChainDriveBlock.Part.NONE);
                }
                return stateIn;
            }
            ChainDriveBlock.Part otherPart = (ChainDriveBlock.Part)neighbour.getValue(PART);
            Direction.Axis otherAxis = (Direction.Axis)neighbour.getValue((Property)AXIS);
            boolean otherConnection = (Boolean)neighbour.getValue((Property)CONNECTED_ALONG_FIRST_COORDINATE);
            Direction.Axis axis2 = otherConnection ? (otherAxis == Direction.Axis.X ? Direction.Axis.Y : Direction.Axis.X) : (otherConnectionAxis = otherAxis == Direction.Axis.Z ? Direction.Axis.Y : Direction.Axis.Z);
            if (neighbour.getValue((Property)AXIS) == faceAxis) {
                return stateIn;
            }
            if (otherPart != ChainDriveBlock.Part.NONE && otherConnectionAxis != faceAxis) {
                return stateIn;
            }
            if (part == ChainDriveBlock.Part.NONE) {
                ChainDriveBlock.Part part2 = part = positive ? ChainDriveBlock.Part.START : ChainDriveBlock.Part.END;
                connectionAlongFirst = axis == Direction.Axis.X ? faceAxis.isVertical() : faceAxis == Direction.Axis.X;
            } else if (connectionAxis != faceAxis) {
                return stateIn;
            }
            if (part == ChainDriveBlock.Part.START != positive) {
                part = ChainDriveBlock.Part.MIDDLE;
            }
            return (BlockState)((BlockState)stateIn.setValue(PART, (Comparable)part)).setValue((Property)CONNECTED_ALONG_FIRST_COORDINATE, (Comparable)Boolean.valueOf(connectionAlongFirst));
        }
        return stateIn;
    }

    public static boolean areCustomBlocksConnected(BlockState state, BlockState other, Direction facing) {
        block3: {
            block2: {
                Block block = state.getBlock();
                if (!(block instanceof CustomChainDriveBlock)) break block2;
                CustomChainDriveBlock b = (CustomChainDriveBlock)block;
                block = other.getBlock();
                if (!(block instanceof CustomChainDriveBlock)) break block2;
                CustomChainDriveBlock b1 = (CustomChainDriveBlock)block;
                if (b.getType().equals(b1.getType())) break block3;
            }
            return false;
        }
        return CustomChainDriveBlock.areBlocksConnected((BlockState)state, (BlockState)other, (Direction)facing);
    }

    public BlockEntityType<? extends KineticBlockEntity> getBlockEntityType() {
        return (BlockEntityType)EncasedBlockEntities.CHAIN_DRIVE.get();
    }
}

