/*
 * Decompiled with CFR 0.152.
 */
package com.zeroregard.ars_technica.mixin;

import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.common.crafting.recipes.CrushRecipe;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectCrush;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import com.zeroregard.ars_technica.helpers.SpellResolverHelpers;
import java.util.IdentityHashMap;
import java.util.List;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={EffectCrush.class})
public class EffectCrushMixin {
    @Unique
    private static final IdentityHashMap<List<?>, SpellResolver> ars_technica$crushedItemTracker = new IdentityHashMap();

    @WrapOperation(method={"onResolve"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;getEntitiesOfClass(Ljava/lang/Class;Lnet/minecraft/world/phys/AABB;)Ljava/util/List;")})
    private List<?> trackCrushedItems(Level instance, Class<?> aClass, AABB aabb, Operation<List<?>> original, @Local(argsOnly=true) SpellResolver resolver, @Local(argsOnly=true) SpellStats spellStats) {
        List ret = (List)original.call(new Object[]{instance, aClass, aabb});
        if (!ret.isEmpty()) {
            ars_technica$crushedItemTracker.put(ret, resolver);
        }
        return ret;
    }

    @WrapOperation(method={"crushItems"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/crafting/RecipeHolder;value()Lnet/minecraft/world/item/crafting/Recipe;")})
    private static <T extends Recipe<?>> T rollForItems(RecipeHolder<CrushRecipe> instance, Operation<CrushRecipe> original, @Local(argsOnly=true) List<ItemEntity> itemEntities) {
        CrushRecipe recipe = EffectCrushMixin.ars_Technica$adaptRecipe((CrushRecipe)instance.value(), ars_technica$crushedItemTracker.get(itemEntities));
        return (T)((Recipe)original.call(new Object[]{new RecipeHolder(instance.id(), (Recipe)recipe)}));
    }

    @Inject(method={"crushItems"}, at={@At(value="RETURN")})
    private static <T extends Recipe<?>> void cleanup(Level world, List<ItemEntity> itemEntities, int maxItemCrush, CallbackInfo ci) {
        ars_technica$crushedItemTracker.remove(itemEntities);
    }

    @WrapOperation(method={"onResolveBlock"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/crafting/RecipeHolder;value()Lnet/minecraft/world/item/crafting/Recipe;")})
    private <T extends Recipe<?>> T rollForBlocks(RecipeHolder<CrushRecipe> instance, Operation<CrushRecipe> original, @Local(argsOnly=true) SpellResolver resolver) {
        CrushRecipe recipe = EffectCrushMixin.ars_Technica$adaptRecipe((CrushRecipe)instance.value(), resolver);
        return (T)((Recipe)original.call(new Object[]{new RecipeHolder(instance.id(), (Recipe)recipe)}));
    }

    @Unique
    private static CrushRecipe ars_Technica$adaptRecipe(CrushRecipe recipe, @Nullable SpellResolver resolver) {
        return SpellResolverHelpers.shouldDoubleOutputs(resolver) ? new CrushRecipe(recipe.input(), recipe.outputs().stream().map(o -> (double)o.chance() < 1.0 ? new CrushRecipe.CrushOutput(o.stack().copyWithCount(Math.min(o.stack().getMaxStackSize(), o.stack().getCount() * 2)), o.chance(), o.maxRange()) : o).toList()) : recipe;
    }
}

