/*
 * Decompiled with CFR 0.152.
 */
package com.zeroregard.ars_technica.entity;

import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.kinetics.press.PressingRecipe;
import com.zeroregard.ars_technica.entity.ArcaneProcessEntity;
import com.zeroregard.ars_technica.helpers.RecipeHelpers;
import com.zeroregard.ars_technica.registry.EntityRegistry;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.Color;
import software.bernie.geckolib.util.GeckoLibUtil;

public class ArcanePressEntity
extends ArcaneProcessEntity
implements GeoEntity {
    AnimatableInstanceCache factory = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public ArcanePressEntity(Vec3 position, Level world, int maxAmountToPress, float speed, Color color, List<ItemEntity> pressableEntities) {
        super((EntityType)EntityRegistry.ARCANE_PRESS_ENTITY.get(), position, world, maxAmountToPress, speed, color, pressableEntities);
    }

    public ArcanePressEntity(EntityType<ArcanePressEntity> entityType, Level world) {
        super(entityType, world);
    }

    @Override
    protected void process(ItemEntity item) {
        this.press(item);
    }

    private void press(ItemEntity item) {
        ItemStack currentStack = item.getItem();
        if (currentStack.getCount() > 0) {
            Optional<RecipeHolder<PressingRecipe>> pressingRecipe = RecipeHelpers.getPressingRecipeForItemStack(currentStack, this.world);
            if (pressingRecipe.isEmpty()) {
                if (this.currentItem != null) {
                    this.processableEntities.remove(this.currentItem);
                    this.currentItem = null;
                }
                return;
            }
            if (this.currentItem != null) {
                Vec3 currentPos = this.currentItem.getPosition(1.0f);
                this.setPos(currentPos.add(0.0, 1.0, 0.0));
            }
            RegistryAccess registryAccess = this.world.registryAccess();
            PressingRecipe recipe = (PressingRecipe)pressingRecipe.get().value();
            ItemStack pressedStack = recipe.getResultItem((HolderLookup.Provider)registryAccess);
            pressedStack.setCount(1);
            this.growOutput(item, pressedStack);
            currentStack.shrink(1);
            ++this.amountProcessed;
            AllSoundEvents.MECHANICAL_PRESS_ACTIVATION.playOnServer(this.world, (Vec3i)this.blockPosition(), 0.5f, 0.75f + this.speed / 16.0f);
        }
        if (currentStack.getCount() <= 0 && this.currentItem != null) {
            this.currentItem = null;
        }
    }

    @Override
    protected boolean canProcessStack(ItemStack stack) {
        Optional<RecipeHolder<PressingRecipe>> pressingRecipe = RecipeHelpers.getPressingRecipeForItemStack(stack, this.world);
        return pressingRecipe.isPresent();
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController((GeoAnimatable)this, "pressController", 0, this::pressAnimationPredicate));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }

    private PlayState pressAnimationPredicate(AnimationState<?> event) {
        event.getController().setAnimation(RawAnimation.begin().thenPlay("press"));
        event.getController().setAnimationSpeed((double)this.speed);
        return PlayState.CONTINUE;
    }
}

