/*
 * Decompiled with CFR 0.152.
 */
package com.zeroregard.ars_technica.client.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.zeroregard.ars_technica.entity.ItemProjectileEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;

public class ItemProjectileRenderer
extends EntityRenderer<ItemProjectileEntity> {
    public static ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"ars_nouveau", (String)"textures/entity/bubble.png");

    public ItemProjectileRenderer(EntityRendererProvider.Context renderManagerIn) {
        super(renderManagerIn);
    }

    public void render(@NotNull ItemProjectileEntity entityIn, float entityYaw, float partialTicks, @NotNull PoseStack matrixStack, @NotNull MultiBufferSource bufferIn, int packedLightIn) {
        super.render((Entity)entityIn, entityYaw, partialTicks, matrixStack, bufferIn, packedLightIn);
        float time = ((float)entityIn.tickCount + partialTicks) / 20.0f;
        float rotationAngle = time * 360.0f;
        matrixStack.pushPose();
        matrixStack.translate(0.0, 0.5, 0.0);
        matrixStack.mulPose(Axis.YP.rotationDegrees(rotationAngle));
        matrixStack.scale(0.25f, 0.25f, 0.25f);
        if (entityIn.getStack() == null) {
            matrixStack.popPose();
            this.renderBubble(matrixStack, bufferIn, packedLightIn);
            return;
        }
        ItemStack stack = entityIn.getStack();
        Minecraft.getInstance().getItemRenderer().renderStatic(stack, ItemDisplayContext.FIXED, 0xF000F0, OverlayTexture.NO_OVERLAY, matrixStack, bufferIn, entityIn.level(), (int)entityIn.blockPosition().asLong());
        matrixStack.popPose();
        this.renderBubble(matrixStack, bufferIn, packedLightIn);
    }

    private void renderBubble(PoseStack matrixStack, MultiBufferSource bufferIn, int packedLightIn) {
        matrixStack.pushPose();
        matrixStack.translate(0.0, 0.5, 0.0);
        matrixStack.mulPose(this.entityRenderDispatcher.cameraOrientation());
        float scale = 0.75f;
        matrixStack.scale(scale, scale, scale);
        VertexConsumer buffer = bufferIn.getBuffer(RenderType.entityTranslucentEmissive((ResourceLocation)TEXTURE, (boolean)true));
        Matrix4f pose = matrixStack.last().pose();
        buffer.addVertex(pose, -0.5f, -0.5f, 0.0f).setColor(255, 255, 255, 128).setUv(0.0f, 0.0f).setOverlay(OverlayTexture.NO_OVERLAY).setUv2(packedLightIn, packedLightIn >> 16).setNormal(0.0f, 1.0f, 0.0f);
        buffer.addVertex(pose, 0.5f, -0.5f, 0.0f).setColor(255, 255, 255, 128).setUv(1.0f, 0.0f).setOverlay(OverlayTexture.NO_OVERLAY).setUv2(packedLightIn, packedLightIn >> 16).setNormal(0.0f, 1.0f, 0.0f);
        buffer.addVertex(pose, 0.5f, 0.5f, 0.0f).setColor(255, 255, 255, 128).setUv(1.0f, 1.0f).setOverlay(OverlayTexture.NO_OVERLAY).setUv2(packedLightIn, packedLightIn >> 16).setNormal(0.0f, 1.0f, 0.0f);
        buffer.addVertex(pose, -0.5f, 0.5f, 0.0f).setColor(255, 255, 255, 128).setUv(0.0f, 1.0f).setOverlay(OverlayTexture.NO_OVERLAY).setUv2(packedLightIn, packedLightIn >> 16).setNormal(0.0f, 1.0f, 0.0f);
        matrixStack.popPose();
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull ItemProjectileEntity entity) {
        return ResourceLocation.fromNamespaceAndPath((String)"ars_nouveau", (String)"textures/entity/spell_proj.png");
    }
}

