/*
 * Decompiled with CFR 0.152.
 */
package dev.nolij.toomanyrecipeviewers.util;

import java.util.Comparator;
import java.util.function.Function;
import net.minecraft.resources.ResourceLocation;

public abstract class ResourceLocationHolderComparator<T>
implements Comparator<T> {
    public static <T> ResourceLocationHolderComparator<T> create(final Function<T, ResourceLocation> getter) {
        return new ResourceLocationHolderComparator<T>(){

            @Override
            public ResourceLocation getResourceLocation(T obj) {
                return (ResourceLocation)getter.apply(obj);
            }
        };
    }

    public abstract ResourceLocation getResourceLocation(T var1);

    private static boolean isVanillaNamespace(ResourceLocation location) {
        return location.getNamespace().equals("minecraft");
    }

    @Override
    public int compare(T _left, T _right) {
        boolean rightIsVanilla;
        ResourceLocation left = this.getResourceLocation(_left);
        ResourceLocation right = this.getResourceLocation(_right);
        boolean leftIsVanilla = ResourceLocationHolderComparator.isVanillaNamespace(left);
        if (leftIsVanilla ^ (rightIsVanilla = ResourceLocationHolderComparator.isVanillaNamespace(right))) {
            if (leftIsVanilla) {
                return -1;
            }
            return 1;
        }
        return left.compareNamespaced(right);
    }
}

