/*
 * Decompiled with CFR 0.152.
 */
package dev.nolij.toomanyrecipeviewers.impl.jei.common.network;

import dev.emi.emi.api.EmiApi;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.recipe.handler.EmiCraftContext;
import dev.emi.emi.api.recipe.handler.StandardRecipeHandler;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.WidgetHolder;
import dev.emi.emi.network.EmiNetwork;
import dev.emi.emi.network.EmiPacket;
import dev.emi.emi.network.FillRecipeC2SPacket;
import dev.emi.emi.platform.EmiClient;
import dev.emi.emi.registry.EmiRecipeFiller;
import dev.nolij.toomanyrecipeviewers.mixin.PacketRecipeTransferAccessor;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import mezz.jei.common.network.IConnectionToServer;
import mezz.jei.common.network.packets.PacketRecipeTransfer;
import mezz.jei.common.network.packets.PlayToServerPacket;
import mezz.jei.common.transfer.TransferOperation;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConnectionToServer
implements IConnectionToServer {
    private final boolean serverHasJEI;

    public ConnectionToServer() {
        ClientPacketListener clientPacketListener = Minecraft.getInstance().getConnection();
        this.serverHasJEI = clientPacketListener == null || clientPacketListener.getConnection().isMemoryConnection() ? false : clientPacketListener.hasChannel(PacketRecipeTransfer.TYPE);
    }

    @Override
    public boolean isJeiOnServer() {
        return true;
    }

    @Override
    public <T extends PlayToServerPacket<T>> void sendPacketToServer(@NotNull T packet) {
        if (!(packet instanceof PacketRecipeTransfer)) {
            return;
        }
        PacketRecipeTransfer recipeTransferPacket = (PacketRecipeTransfer)packet;
        if (this.serverHasJEI) {
            PacketDistributor.sendToServer((CustomPacketPayload)recipeTransferPacket, (CustomPacketPayload[])new CustomPacketPayload[0]);
            return;
        }
        ConnectionToServer.handle(recipeTransferPacket);
    }

    public static void handle(PacketRecipeTransfer recipeTransferPacket) {
        AbstractContainerScreen containerScreen = EmiApi.getHandledScreen();
        if (containerScreen == null) {
            return;
        }
        AbstractContainerMenu containerMenu = containerScreen.getMenu();
        final List<Slot> inventorySlots = recipeTransferPacket.inventorySlots.stream().map(arg_0 -> ((AbstractContainerMenu)containerMenu).getSlot(arg_0)).toList();
        final List<Slot> craftingSlots = recipeTransferPacket.craftingSlots.stream().map(arg_0 -> ((AbstractContainerMenu)containerMenu).getSlot(arg_0)).toList();
        int[] craftingSlotIndex = craftingSlots.stream().mapToInt(s -> s.index).toArray();
        ArrayList<Optional<TransferOperation>> transferOperationIndex = new ArrayList<Optional<TransferOperation>>(craftingSlots.size());
        for (int craftingSlotId : craftingSlotIndex) {
            transferOperationIndex.add(recipeTransferPacket.transferOperations.stream().filter(x -> x.craftingSlotId() == craftingSlotId).findFirst());
        }
        StandardRecipeHandler fakeRecipeHandler = new StandardRecipeHandler(){

            public List<Slot> getInputSources(AbstractContainerMenu handler) {
                return inventorySlots;
            }

            public List<Slot> getCraftingSlots(AbstractContainerMenu handler) {
                return craftingSlots;
            }

            public boolean supportsRecipe(EmiRecipe recipe) {
                return true;
            }
        };
        final List<EmiIngredient> fakeIngredients = transferOperationIndex.stream().map(o -> o.map(t -> containerMenu.getSlot(t.inventorySlotId()))).map(o -> o.map(s -> s.getItem().copyWithCount(1))).map(o -> o.map(EmiStack::of).orElse(EmiStack.EMPTY)).map(EmiIngredient.class::cast).toList();
        EmiRecipe fakeRecipe = new EmiRecipe(){

            public EmiRecipeCategory getCategory() {
                throw new UnsupportedOperationException();
            }

            @Nullable
            public ResourceLocation getId() {
                throw new UnsupportedOperationException();
            }

            public List<EmiIngredient> getInputs() {
                return fakeIngredients;
            }

            public List<EmiStack> getOutputs() {
                return List.of();
            }

            public int getDisplayWidth() {
                throw new UnsupportedOperationException();
            }

            public int getDisplayHeight() {
                throw new UnsupportedOperationException();
            }

            public void addWidgets(WidgetHolder widgets) {
                throw new UnsupportedOperationException();
            }
        };
        List stacks = EmiRecipeFiller.getStacks((StandardRecipeHandler)fakeRecipeHandler, (EmiRecipe)fakeRecipe, (AbstractContainerScreen)containerScreen, (int)(((PacketRecipeTransferAccessor)((Object)recipeTransferPacket)).tmrv$isMaxTransfer() ? Integer.MAX_VALUE : 1));
        if (EmiClient.onServer) {
            EmiNetwork.sendToServer((EmiPacket)new FillRecipeC2SPacket(containerMenu, 0, inventorySlots, craftingSlots, null, stacks));
        } else {
            EmiRecipeFiller.clientFill((StandardRecipeHandler)fakeRecipeHandler, null, (AbstractContainerScreen)containerScreen, (List)stacks, (EmiCraftContext.Destination)EmiCraftContext.Destination.NONE);
        }
    }
}

