/*
 * Decompiled with CFR 0.152.
 */
package dev.nolij.toomanyrecipeviewers.impl.jei.api.gui.builder;

import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.nolij.toomanyrecipeviewers.impl.jei.api.gui.builder.RecipeSlotBuilder;
import dev.nolij.toomanyrecipeviewers.impl.jei.api.runtime.IngredientManager;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.gui.builder.IIngredientAcceptor;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.widgets.ISlottedWidgetFactory;
import mezz.jei.api.recipe.RecipeIngredientRole;

public class RecipeLayoutBuilder
implements IRecipeLayoutBuilder {
    private final IngredientManager ingredientManager;
    private final List<RecipeSlotBuilder> slots = new ArrayList<RecipeSlotBuilder>();
    private boolean shapeless = false;

    public RecipeLayoutBuilder(IngredientManager ingredientManager) {
        this.ingredientManager = ingredientManager;
    }

    public ExtractedEMIRecipeData extractEMIRecipeData() {
        List<RecipeSlotBuilder> outputSlots = this.slots.stream().filter(x -> x.role == RecipeIngredientRole.OUTPUT).toList();
        ArrayList<EmiStack> outputs = new ArrayList<EmiStack>();
        boolean supportsRecipeTree = true;
        for (RecipeSlotBuilder outputSlot : outputSlots) {
            List<EmiStack> stacks = outputSlot.getEMIStacks();
            outputs.addAll(stacks);
            if (!supportsRecipeTree || stacks.size() <= 1) continue;
            supportsRecipeTree = false;
        }
        return new ExtractedEMIRecipeData(this.slots.stream().filter(x -> x.role == RecipeIngredientRole.INPUT).map(RecipeSlotBuilder::getEMIIngredient).toList(), this.slots.stream().filter(x -> x.role == RecipeIngredientRole.CATALYST).map(RecipeSlotBuilder::getEMIIngredient).toList(), outputs, this.shapeless, supportsRecipeTree);
    }

    public List<RecipeSlotBuilder> getSlots() {
        return this.slots;
    }

    @Override
    public IRecipeSlotBuilder addSlot(RecipeIngredientRole role) {
        RecipeSlotBuilder slot = new RecipeSlotBuilder(this.ingredientManager, role);
        this.slots.add(slot);
        return slot;
    }

    @Override
    public IRecipeSlotBuilder addSlotToWidget(RecipeIngredientRole role, ISlottedWidgetFactory<?> widgetFactory) {
        return this.addSlot(role);
    }

    @Override
    public IIngredientAcceptor<?> addInvisibleIngredients(RecipeIngredientRole role) {
        return ((RecipeSlotBuilder)this.addSlot(role)).setInvisible();
    }

    @Override
    public void moveRecipeTransferButton(int x, int y) {
    }

    @Override
    public void setShapeless() {
        this.shapeless = true;
    }

    @Override
    public void setShapeless(int x, int y) {
        this.shapeless = true;
    }

    @Override
    public void createFocusLink(IIngredientAcceptor<?> ... ingredientAcceptors) {
    }

    public record ExtractedEMIRecipeData(List<EmiIngredient> inputs, List<EmiIngredient> catalysts, List<EmiStack> outputs, boolean shapeless, boolean supportsRecipeTree) {
    }
}

