/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbbackups.archival;

import dev.ftb.mods.ftbbackups.api.IArchivalPlugin;
import dev.ftb.mods.ftbbackups.api.event.RegisterArchivalPluginEvent;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import org.jetbrains.annotations.Nullable;

public class ArchivePluginManager {
    private static final ArchivePluginManager CLIENT = new ArchivePluginManager();
    private static final ArchivePluginManager SERVER = new ArchivePluginManager();
    private final Map<ResourceLocation, IArchivalPlugin> plugins = new ConcurrentHashMap<ResourceLocation, IArchivalPlugin>();
    private static boolean pluginsRegistered = false;

    public static ArchivePluginManager clientInstance() {
        if (!pluginsRegistered) {
            NeoForge.EVENT_BUS.post((Event)new RegisterArchivalPluginEvent(CLIENT::register));
            pluginsRegistered = true;
        }
        return CLIENT;
    }

    public static ArchivePluginManager serverInstance() {
        return SERVER;
    }

    public synchronized void register(IArchivalPlugin plugin) {
        if (this.plugins.containsKey(plugin.getId())) {
            throw new IllegalStateException("archival plugin " + String.valueOf(plugin.getId()) + " already registered!");
        }
        this.plugins.put(plugin.getId(), plugin);
    }

    @Nullable
    public IArchivalPlugin getPlugin(ResourceLocation id) {
        return this.plugins.get(id);
    }

    public void clear() {
        this.plugins.clear();
    }

    public Map<ResourceLocation, IArchivalPlugin> plugins() {
        return Collections.unmodifiableMap(this.plugins);
    }
}

