/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbbackups;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.tree.CommandNode;
import dev.architectury.networking.NetworkManager;
import dev.ftb.mods.ftbbackups.BackupUtils;
import dev.ftb.mods.ftbbackups.Backups;
import dev.ftb.mods.ftbbackups.config.FTBBackupsServerConfig;
import dev.ftb.mods.ftblibrary.net.EditConfigChoicePacket;
import java.time.Duration;
import java.time.Instant;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.storage.LevelResource;

public class BackupCommands {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralArgumentBuilder backupCommands = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"ftbbackups3").then(Commands.literal((String)"time").executes(ctx -> BackupCommands.time((CommandSourceStack)ctx.getSource())))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"start").requires(BackupCommands::isAdmin)).then(Commands.argument((String)"name", (ArgumentType)StringArgumentType.word()).executes(ctx -> BackupCommands.start((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"name"))))).executes(ctx -> BackupCommands.start((CommandSourceStack)ctx.getSource(), "")))).then(((LiteralArgumentBuilder)Commands.literal((String)"size").requires(BackupCommands::isAdmin)).executes(ctx -> BackupCommands.size((CommandSourceStack)ctx.getSource())))).then(((LiteralArgumentBuilder)Commands.literal((String)"status").requires(BackupCommands::isAdmin)).executes(ctx -> BackupCommands.status((CommandSourceStack)ctx.getSource())))).then(((LiteralArgumentBuilder)Commands.literal((String)"reset").requires(BackupCommands::isAdmin)).executes(ctx -> BackupCommands.resetState((CommandSourceStack)ctx.getSource())))).then(((LiteralArgumentBuilder)Commands.literal((String)"serverconfig").requires(BackupCommands::isAdmin)).executes(ctx -> BackupCommands.editServerConfig((CommandSourceStack)ctx.getSource())))).then(((LiteralArgumentBuilder)Commands.literal((String)"clientconfig").requires(CommandSourceStack::isPlayer)).executes(ctx -> BackupCommands.editClientConfig((CommandSourceStack)ctx.getSource())))).then(((LiteralArgumentBuilder)Commands.literal((String)"config").requires(CommandSourceStack::isPlayer)).executes(ctx -> BackupCommands.editConfig((CommandSourceStack)ctx.getSource())));
        dispatcher.register(backupCommands);
        if (((Boolean)FTBBackupsServerConfig.ADD_BACKUP_COMMAND_ALIAS.get()).booleanValue()) {
            dispatcher.register((LiteralArgumentBuilder)Commands.literal((String)"backup").redirect((CommandNode)backupCommands.build()));
        }
    }

    private static boolean isAdmin(CommandSourceStack cs) {
        return cs.getServer().isSingleplayer() || cs.hasPermission(3);
    }

    private static int editServerConfig(CommandSourceStack source) throws CommandSyntaxException {
        NetworkManager.sendToPlayer((ServerPlayer)source.getPlayerOrException(), (CustomPacketPayload)EditConfigChoicePacket.server((String)"ftbbackups3-server"));
        return 1;
    }

    private static int editClientConfig(CommandSourceStack source) throws CommandSyntaxException {
        NetworkManager.sendToPlayer((ServerPlayer)source.getPlayerOrException(), (CustomPacketPayload)EditConfigChoicePacket.client((String)"ftbbackups3-client"));
        return 1;
    }

    private static int editConfig(CommandSourceStack source) throws CommandSyntaxException {
        NetworkManager.sendToPlayer((ServerPlayer)source.getPlayerOrException(), (CustomPacketPayload)EditConfigChoicePacket.choose((String)"ftbbackups3-client", (String)"ftbbackups3-server", (Component)Component.literal((String)"FTB Backups 3")));
        return 1;
    }

    private static int time(CommandSourceStack source) {
        Duration d = Duration.between(Instant.now(), Instant.ofEpochMilli(Backups.getServerInstance().nextBackupTime));
        String key = d.isNegative() ? "ftbbackups3.lang.timer.in_past" : "ftbbackups3.lang.timer";
        Duration a = d.abs();
        MutableComponent msg = Component.translatable((String)key, (Object[])new Object[]{String.format("%02d:%02d:%02d", a.toHoursPart(), a.toMinutesPart(), a.toSecondsPart())});
        source.sendSuccess(() -> BackupCommands.lambda$time$9((Component)msg), true);
        if (d.isNegative() && ((Boolean)FTBBackupsServerConfig.ONLY_IF_PLAYERS_ONLINE.get()).booleanValue()) {
            source.sendSuccess(() -> Component.translatable((String)"ftbbackups3.lang.timer.no_players"), true);
        }
        return 1;
    }

    private static int start(CommandSourceStack source, String customName) {
        if (Backups.getServerInstance().run(source.getServer(), false, source.getDisplayName(), customName)) {
            for (ServerPlayer player : source.getServer().getPlayerList().getPlayers()) {
                player.sendSystemMessage((Component)Component.translatable((String)"ftbbackups3.lang.manual_launch", (Object[])new Object[]{source.getDisplayName()}));
            }
        } else {
            source.sendSuccess(() -> Component.translatable((String)"ftbbackups3.lang.already_running"), true);
        }
        return 1;
    }

    private static int size(CommandSourceStack source) {
        long totalSize = Backups.getServerInstance().totalBackupSize();
        source.sendSuccess(() -> Component.translatable((String)"ftbbackups3.lang.size.current", (Object[])new Object[]{BackupUtils.formatSizeString(source.getServer().getWorldPath(LevelResource.ROOT))}), true);
        source.sendSuccess(() -> Component.translatable((String)"ftbbackups3.lang.size.total", (Object[])new Object[]{BackupUtils.formatSizeString(totalSize)}), true);
        source.sendSuccess(() -> Component.translatable((String)"ftbbackups3.lang.size.available", (Object[])new Object[]{BackupUtils.formatSizeString(Math.min((Long)FTBBackupsServerConfig.MAX_TOTAL_SIZE.get(), Backups.getServerInstance().backupsFolder.toFile().getFreeSpace()))}), true);
        return 1;
    }

    private static int status(CommandSourceStack source) {
        source.getServer().getAllLevels().forEach(level -> {
            if (level != null) {
                MutableComponent enabled = Component.translatable((String)("ftbbackups3.lang.autosave." + (level.noSave() ? "disabled" : "enabled"))).withStyle(ChatFormatting.AQUA);
                MutableComponent dim = Component.literal((String)level.dimension().location().toString()).withStyle(ChatFormatting.YELLOW);
                source.sendSuccess(() -> BackupCommands.lambda$status$15((Component)dim, (Component)enabled), true);
            }
        });
        return 1;
    }

    @Deprecated(forRemoval=true, since="21.1.0")
    private static int resetState(CommandSourceStack source) {
        source.getServer().getAllLevels().forEach(level -> {
            if (level != null) {
                source.sendSuccess(() -> Component.literal((String)("Reseting state + saving for " + String.valueOf(level.dimension().location()))), true);
                level.noSave = false;
                level.save(null, true, true);
            }
        });
        source.sendSuccess(() -> Component.literal((String)"Reseting state + saving for players"), true);
        source.getServer().getPlayerList().saveAll();
        return 1;
    }

    private static /* synthetic */ Component lambda$status$15(Component dim, Component enabled) {
        return Component.translatable((String)"ftbbackups3.lang.autosave_status", (Object[])new Object[]{dim, enabled});
    }

    private static /* synthetic */ Component lambda$time$9(Component msg) {
        return msg;
    }
}

