/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.enderchests.modintegration.theoneprobe;

import java.util.ArrayList;
import java.util.List;
import mcjty.theoneprobe.api.IElement;
import mcjty.theoneprobe.api.IElementFactory;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoProvider;
import mcjty.theoneprobe.api.ProbeMode;
import mcjty.theoneprobe.apiimpl.client.ElementTextRender;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import shetiphian.enderchests.EnderChests;
import shetiphian.enderchests.common.block.BlockEnderChest;
import shetiphian.enderchests.common.misc.ChestInfoHelper;
import shetiphian.enderchests.common.tileentity.TileEntityEnderChest;

public final class OneProbeDataProvider
implements IProbeInfoProvider {
    static final OneProbeDataProvider INSTANCE = new OneProbeDataProvider();
    private static final ResourceLocation INFO_PROVIDER_ID = EnderChests.RESOURCE.apply("default");
    private static final ResourceLocation ELEMENT_ID = EnderChests.RESOURCE.apply("element");

    public ResourceLocation getID() {
        return INFO_PROVIDER_ID;
    }

    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, Player player, Level world, BlockState blockState, IProbeHitData data) {
        BlockEntity tile;
        if (blockState.getBlock() instanceof BlockEnderChest && (tile = world.getBlockEntity(data.getPos())) instanceof TileEntityEnderChest) {
            probeInfo.element((IElement)new ElementChestInfo((TileEntityEnderChest)tile, !mode.equals((Object)ProbeMode.NORMAL)));
        }
    }

    private static class ElementChestInfo
    implements IElement {
        private TileEntityEnderChest chest;
        private CompoundTag data;
        private final List<Component> lines = new ArrayList<Component>();

        private ElementChestInfo(TileEntityEnderChest chest, boolean showDetails) {
            this.chest = chest;
        }

        private ElementChestInfo(CompoundTag data, HolderLookup.Provider provider) {
            if (data == null || data.isEmpty()) {
                this.data = new CompoundTag();
                return;
            }
            this.data = data;
            if (data.contains("basic")) {
                ChestInfoHelper.unpackHUDInfo(this.lines, data.getList("basic", 8), provider);
            }
        }

        public void render(GuiGraphics graphics, int x, int y) {
            int indent = this.lines.size() - 1;
            int counter = 0;
            for (Component line : this.lines) {
                ElementTextRender.render((Component)line, (GuiGraphics)graphics, (int)(counter < indent ? x : x + 10), (int)y);
                y += 10;
                ++counter;
            }
        }

        public int getWidth() {
            int width = 0;
            for (Component line : this.lines) {
                width = Math.max(width, ElementTextRender.getWidth((Component)line));
            }
            return width;
        }

        public int getHeight() {
            return 10 + (this.lines.size() - 1) * 10;
        }

        public void toBytes(RegistryFriendlyByteBuf buffer) {
            if (this.data == null && this.chest != null) {
                this.data = new CompoundTag();
                this.data.put("basic", (Tag)ChestInfoHelper.packHUDBasic(this.chest, (HolderLookup.Provider)buffer.registryAccess()));
            }
            if (this.data != null) {
                buffer.writeNbt((Tag)this.data);
            }
        }

        public ResourceLocation getID() {
            return ELEMENT_ID;
        }
    }

    static class ElementFactoryChestInfo
    implements IElementFactory {
        ElementFactoryChestInfo() {
        }

        public IElement createElement(RegistryFriendlyByteBuf buffer) {
            return new ElementChestInfo(buffer.readNbt(), (HolderLookup.Provider)buffer.registryAccess());
        }

        public ResourceLocation getId() {
            return ELEMENT_ID;
        }
    }
}

