/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.enderchests.modintegration;

import net.neoforged.fml.ModList;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import shetiphian.enderchests.Configs;
import shetiphian.enderchests.EnderChests;

public final class ModIntegration {
    public static final ModIntegration INSTANCE = new ModIntegration();
    private static final String BASE = "shetiphian.enderchests.modintegration.";
    private static final ClassLoader LOADER = EnderChests.class.getClassLoader();

    public void initCapabilities(RegisterCapabilitiesEvent event) {
        if (((Boolean)Configs.INTEGRATION.enableCurios.get()).booleanValue()) {
            this.load("curios.Curios_Active", "init", event);
        }
    }

    public void init() {
        this.loadAPIs();
        this.sendComms();
    }

    private void loadAPIs() {
    }

    private void load(String name, String method) {
        this.load(name, method, new Object[0]);
    }

    private void load(String name, String method, Object ... args) {
        Class[] classes = new Class[args.length];
        for (int index = 0; index < args.length; ++index) {
            classes[0] = args[0].getClass();
        }
        try {
            LOADER.loadClass(BASE + name).getMethod(method, classes).invoke(null, args);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void loadAPI(String name) {
        try {
            LOADER.loadClass(BASE + name).getMethod("init", new Class[0]).invoke(null, new Object[0]);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void sendComms() {
        if (ModList.get().isLoaded("theoneprobe")) {
            this.sendIsolatedComms("theoneprobe.TheOneProbe_Active");
        }
    }

    private void sendIsolatedComms(String name) {
        try {
            LOADER.loadClass(BASE + name).getMethod("sendComms", new Class[0]).invoke(null, new Object[0]);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

