/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.enderchests.common.misc;

import com.google.common.base.Strings;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;
import shetiphian.core.common.NameCache;
import shetiphian.enderchests.common.misc.ChestHelper;
import shetiphian.enderchests.common.tileentity.TileEntityEnderChest;

public class ChestInfoHelper {
    private static final Style GOLD = Style.EMPTY.withColor(TextColor.fromLegacyFormat((ChatFormatting)ChatFormatting.GOLD));
    private static final Style GREEN = Style.EMPTY.withColor(TextColor.fromLegacyFormat((ChatFormatting)ChatFormatting.GREEN));
    private static final Style AQUA = Style.EMPTY.withColor(TextColor.fromLegacyFormat((ChatFormatting)ChatFormatting.AQUA));
    private static final Style BOLD_RED = Style.EMPTY.withColor(TextColor.fromLegacyFormat((ChatFormatting)ChatFormatting.RED)).withBold(Boolean.valueOf(true));
    private static final Component DUMMY = Component.literal((String)"");

    public static void unpackHUDInfo(List<Component> lines, ListTag listNBT, HolderLookup.Provider provider) {
        listNBT.forEach(tag -> lines.add((Component)Component.Serializer.fromJson((String)tag.getAsString(), (HolderLookup.Provider)provider)));
    }

    private static StringTag toTag(Component entry, HolderLookup.Provider provider) {
        return StringTag.valueOf((String)Component.Serializer.toJson((Component)entry, (HolderLookup.Provider)provider));
    }

    public static ListTag packHUDBasic(TileEntityEnderChest tile, HolderLookup.Provider provider) {
        ListTag listNBT = new ListTag();
        listNBT.add((Object)ChestInfoHelper.toTag(ChestInfoHelper.infoChestOwner(tile.getOwnerName(), true), provider));
        listNBT.add((Object)ChestInfoHelper.toTag((Component)Component.literal((String)" ").append((Component)Component.translatable((String)"info.enderchests.chest.code")).append((Component)Component.literal((String)(" " + tile.getCode()))), provider));
        return listNBT;
    }

    public static void sendCapacityInfo(Player player, TileEntityEnderChest chestTile) {
        ChestInfoHelper.sendInfo(player, Component.translatable((String)"info.enderchests.chest.capacity").append(" " + ChestHelper.getCapacity(player.level(), chestTile.getOwnerID(), chestTile.getCode())));
    }

    public static void sendLinkError(Player player, int error) {
        ChestInfoHelper.sendInfo(player, Component.translatable((String)("error.enderchests.bag.nolink" + error)).setStyle(BOLD_RED));
    }

    public static void sendError(Player player, String error) {
        ChestInfoHelper.sendInfo(player, Component.translatable((String)("error." + error)).setStyle(BOLD_RED));
    }

    public static Component infoChestOwner(String owner, boolean displayPublic) {
        if (Strings.isNullOrEmpty((String)owner) || owner.equalsIgnoreCase("all")) {
            if (displayPublic) {
                String color = "\u00a76";
                return Component.literal((String)" ").append((Component)Component.literal((String)(color + "[-"))).append((Component)Component.translatable((String)"info.enderchests.chest.public").setStyle(GOLD)).append((Component)Component.literal((String)(color + "-]")));
            }
            return DUMMY;
        }
        boolean isTeam = owner.startsWith("#");
        String color = isTeam ? "\u00a7a" : "\u00a7b";
        return Component.literal((String)" ").append((Component)Component.literal((String)(color + "[-"))).append((Component)Component.literal((String)owner.substring(isTeam ? 1 : 0)).setStyle(isTeam ? GREEN : AQUA)).append((Component)Component.literal((String)(color + "-]")));
    }

    @Nullable
    public static Component formatChestOwner(String owner) {
        Component component = ChestInfoHelper.infoChestOwner(owner, false);
        return component != DUMMY ? component : null;
    }

    private static void sendInfo(Player player, MutableComponent message) {
        if (player != null) {
            player.displayClientMessage((Component)message, true);
        }
    }

    public static String getDisplayNameFromOwnerID(String ownerID) {
        if (Strings.isNullOrEmpty((String)ownerID) || ownerID.equalsIgnoreCase("all")) {
            return "all";
        }
        if (ownerID.startsWith("#")) {
            return "#" + NameCache.getDisplayNameFor((String)ownerID.substring(1));
        }
        return NameCache.getDisplayNameFor((String)ownerID);
    }
}

