/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.enderchests.common.misc;

import com.google.common.base.Function;
import com.google.common.base.Strings;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import com.mojang.datafixers.DataFixer;
import java.io.File;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.SharedConstants;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;
import net.minecraft.world.level.storage.LevelResource;
import org.slf4j.Logger;
import shetiphian.core.SideExecutor;
import shetiphian.core.common.NBTFile;
import shetiphian.core.common.inventory.InventoryInternal;
import shetiphian.core.mixins.SPC_Accessor_DataStorage;
import shetiphian.enderchests.EnderChests;
import shetiphian.enderchests.common.misc.ChestData;
import shetiphian.enderchests.common.misc.LocationManager;

public class ChestHelper {
    public static final ChestHelper INSTANCE = new ChestHelper();
    private static final Table<String, String, ChestData> DATABASE = HashBasedTable.create();
    private static final Table<String, String, ChestData> CLIENT_CACHE = HashBasedTable.create();
    private static final SavedData.Factory<ChestSaveData> SAVE_DATA_TYPE = new SavedData.Factory(ChestSaveData::new, ChestSaveData::load, null);
    private static ChestSaveData SAVE_INSTANCE;
    private DataFixer saveFixer;
    private static boolean needsSaving;
    private static boolean isLoaded;
    private static String saveDir;
    private static final DateTimeFormatter TIME_FORMATTER;

    private static ChestData getChestData(Level world, String owner, String code) {
        Table<String, String, ChestData> database = world == null ? (SideExecutor.isLogicalServer() ? DATABASE : CLIENT_CACHE) : (world.isClientSide() ? CLIENT_CACHE : DATABASE);
        ChestData chestData = (ChestData)((Object)database.get((Object)(owner = owner.toLowerCase()), (Object)(code = code.toUpperCase())));
        if (chestData == null) {
            chestData = new ChestData(owner, code);
            database.put((Object)owner, (Object)code, (Object)chestData);
        }
        return chestData;
    }

    public static InventoryInternal getChest(Level world, String owner, String code) {
        return ChestHelper.getChestData(world, owner, code);
    }

    public static short getCapacity(Level world, String owner, String code) {
        return (short)ChestHelper.getChestData(world, owner, code).getContainerSize();
    }

    public static void setCapacity(Level world, String owner, String code, byte capacity) {
        ChestHelper.getChestData(world, owner, code).setCapacity(capacity);
    }

    public static void setNeedsSaving() {
        if (SAVE_INSTANCE != null) {
            needsSaving = true;
            SAVE_INSTANCE.setDirty();
        }
    }

    public void onWorldLoad(MinecraftServer server, ServerLevel world, Function<String, LevelResource> getter) {
        SPC_Accessor_DataStorage storageAccessor;
        saveDir = server.getWorldPath((LevelResource)getter.apply((Object)"data/enderchests")).toString();
        DimensionDataStorage dataStorage = world.getDataStorage();
        if (dataStorage instanceof SPC_Accessor_DataStorage) {
            storageAccessor = (SPC_Accessor_DataStorage)dataStorage;
            this.saveFixer = storageAccessor.getFixerUpper();
        }
        if ((SAVE_INSTANCE = (ChestSaveData)dataStorage.get(SAVE_DATA_TYPE, "enderchests")) == null) {
            if (dataStorage instanceof SPC_Accessor_DataStorage) {
                storageAccessor = (SPC_Accessor_DataStorage)dataStorage;
                SAVE_INSTANCE = (ChestSaveData)((Object)SAVE_DATA_TYPE.deserializer().apply(null, storageAccessor.getRegistries()));
            } else {
                SAVE_INSTANCE = (ChestSaveData)((Object)SAVE_DATA_TYPE.constructor().get());
            }
            dataStorage.set("enderchests", (SavedData)SAVE_INSTANCE);
        }
    }

    private void saveChestData(HolderLookup.Provider provider) {
        if (Strings.isNullOrEmpty((String)saveDir)) {
            saveDir = "sp_recovery" + File.separator + "enderchests" + File.separator + TIME_FORMATTER.format(LocalDateTime.now());
            EnderChests.LOGGER.error("World Save Directory Unknown, Saving to Recovery Folder: " + saveDir);
        }
        Set networks = DATABASE.rowKeySet();
        for (String owner : networks) {
            Map networkMap = DATABASE.row((Object)owner);
            CompoundTag fileNBT = new CompoundTag();
            for (Map.Entry pocket : networkMap.entrySet()) {
                if (!((ChestData)((Object)pocket.getValue())).saveCheck()) continue;
                CompoundTag nbtPocket = ((ChestData)((Object)pocket.getValue())).saveToNBT(new CompoundTag(), provider);
                fileNBT.put((String)pocket.getKey(), (Tag)nbtPocket);
            }
            NbtUtils.addCurrentDataVersion((CompoundTag)fileNBT);
            NBTFile.write((CompoundTag)fileNBT, (File)this.getSaveFile(owner), (Logger)EnderChests.LOGGER);
        }
        needsSaving = false;
    }

    private void loadChestData(HolderLookup.Provider provider) {
        LocationManager.clear();
        int gameDataVersion = SharedConstants.getCurrentVersion().getDataVersion().getVersion();
        List<File> fileList = this.getSaveFiles();
        for (File file : fileList) {
            String owner = this.getOwnerID(file.getName().replace(".dat", ""));
            CompoundTag fileNBT = NBTFile.read((File)file, (Logger)EnderChests.LOGGER);
            int fileDataVersion = NbtUtils.getDataVersion((CompoundTag)fileNBT, (int)1343);
            for (String code : fileNBT.getAllKeys()) {
                CompoundTag data = fileNBT.getCompound(code);
                code = code.toUpperCase();
                DATABASE.put((Object)owner, (Object)code, (Object)new ChestData(owner, code).loadFromNBT(data, provider, this.saveFixer, fileDataVersion, gameDataVersion));
            }
        }
        isLoaded = true;
    }

    public void unloadChestData() {
        boolean doMessage = false;
        if (isLoaded) {
            EnderChests.LOGGER.debug("Unloading EnderChest Data");
            doMessage = true;
        }
        CLIENT_CACHE.clear();
        DATABASE.clear();
        isLoaded = false;
        LocationManager.clear();
        if (doMessage) {
            EnderChests.LOGGER.info("EnderChest Data Unloaded");
        }
    }

    private List<File> getSaveFiles() {
        ArrayList<File> fileList = new ArrayList<File>();
        File[] listOfFiles = null;
        try {
            File saveFolder = new File(saveDir);
            listOfFiles = saveFolder.listFiles();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (listOfFiles != null) {
            for (File file : listOfFiles) {
                if (!file.isFile() || !file.canRead() || !file.getName().endsWith(".dat")) continue;
                fileList.add(file);
            }
        }
        return fileList;
    }

    private File getSaveFile(String owner) {
        File file = new File(saveDir);
        if (!file.exists()) {
            file.mkdirs();
        }
        if (!(file = new File(saveDir, this.getSaveID(owner) + ".dat")).exists()) {
            try {
                file.createNewFile();
            }
            catch (Exception error) {
                EnderChests.LOGGER.error("Could Not Read or Create File: " + String.valueOf(file), (Throwable)error);
            }
        }
        return file;
    }

    private String getSaveID(String owner) {
        return owner.equalsIgnoreCase("all") ? "[-Public-]" : owner;
    }

    private String getOwnerID(String owner) {
        return owner.equalsIgnoreCase("[-Public-]") ? "all" : owner;
    }

    static {
        needsSaving = false;
        isLoaded = false;
        saveDir = null;
        TIME_FORMATTER = DateTimeFormatter.ofPattern("yy-MM-dd-HH-mm");
    }

    private static class ChestSaveData
    extends SavedData {
        private ChestSaveData() {
        }

        public CompoundTag save(CompoundTag doNotEdit, HolderLookup.Provider provider) {
            if (needsSaving && isLoaded) {
                EnderChests.LOGGER.debug("Saving EnderChest Data");
                INSTANCE.saveChestData(provider);
                EnderChests.LOGGER.info("EnderChest Data Saved");
            }
            return doNotEdit;
        }

        private static ChestSaveData load(CompoundTag doNotEdit, HolderLookup.Provider provider) {
            INSTANCE.unloadChestData();
            EnderChests.LOGGER.debug("Loading EnderChest Data");
            INSTANCE.loadChestData(provider);
            EnderChests.LOGGER.info("EnderChest Data Loaded");
            return new ChestSaveData();
        }
    }
}

