/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.enderchests.common.misc;

import com.mojang.datafixers.DataFixer;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.util.Mth;
import net.minecraft.util.datafix.fixes.References;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import shetiphian.core.common.inventory.InventoryInternal;
import shetiphian.enderchests.Configs;
import shetiphian.enderchests.common.misc.ChestHelper;
import shetiphian.enderchests.common.misc.LocationManager;

class ChestData
extends InventoryInternal {
    private final String owner;
    private final String code;
    private byte capacity = (byte)9;

    ChestData(String owner, String code) {
        super(null, "", 54, 64, owner.toLowerCase() + "." + code.toLowerCase());
        this.owner = owner;
        this.code = code;
    }

    void setCapacity(byte capacity) {
        this.capacity = (byte)Mth.clamp((int)capacity, (int)Configs.PROCESSED.chestSizeMin.get(), (int)Configs.PROCESSED.chestSizeMax.get());
        ChestHelper.setNeedsSaving();
        LocationManager.doBlockUpdate(this.owner, this.code);
    }

    CompoundTag saveToNBT(CompoundTag nbtTag, HolderLookup.Provider provider) {
        ListTag nbtList = new ListTag();
        for (int index = 0; index < Math.min(this.contents.length, 256); ++index) {
            if (this.contents[index].isEmpty()) continue;
            CompoundTag nbtCompound = (CompoundTag)this.contents[index].save(provider);
            nbtCompound.putByte("Slot", (byte)index);
            nbtList.add((Object)nbtCompound);
        }
        nbtTag.put("Items", (Tag)nbtList);
        nbtTag.putByte("Capacity", this.capacity);
        return nbtTag;
    }

    ChestData loadFromNBT(CompoundTag nbtTag, HolderLookup.Provider provider, DataFixer dataFixer, int fileDataVersion, int gameDataVersion) {
        this.clearContent();
        boolean runFixer = fileDataVersion != gameDataVersion && dataFixer != null;
        this.setCapacity(nbtTag.getByte("Capacity"));
        ListTag nbtList = nbtTag.getList("Items", 10);
        for (int index = 0; index < nbtList.size(); ++index) {
            CompoundTag nbtCompound = nbtList.getCompound(index);
            int slot = nbtCompound.getByte("Slot") & 0xFF;
            if (slot >= this.contents.length) continue;
            if (runFixer) {
                nbtCompound = (CompoundTag)dataFixer.update(References.ITEM_STACK, new Dynamic((DynamicOps)NbtOps.INSTANCE, (Object)nbtCompound), fileDataVersion, gameDataVersion).getValue();
            }
            this.contents[slot] = ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)nbtCompound);
        }
        return this;
    }

    boolean saveCheck() {
        if (this.capacity > Configs.PROCESSED.chestSizeMin.get()) {
            return true;
        }
        for (ItemStack content : this.contents) {
            if (content.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public int getContainerSize() {
        return Mth.clamp((int)this.capacity, (int)Configs.PROCESSED.chestSizeMin.get(), (int)Configs.PROCESSED.chestSizeMax.get());
    }

    public void setChanged() {
        ChestHelper.setNeedsSaving();
        LocationManager.doBlockUpdate(this.owner, this.code);
    }

    public boolean stillValid(Player player) {
        return true;
    }

    public void startOpen(Player player) {
    }

    public void stopOpen(Player player) {
    }
}

