/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.enderchests.common.item;

import com.google.common.base.Strings;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import shetiphian.core.SideExecutor;
import shetiphian.core.client.ClientHelpers;
import shetiphian.core.client.ColorHandler;
import shetiphian.core.common.Helpers;
import shetiphian.core.common.IColored;
import shetiphian.core.common.ITabFiller;
import shetiphian.core.common.inventory.MenuProviderWithData;
import shetiphian.core.platform.Services;
import shetiphian.enderchests.Configs;
import shetiphian.enderchests.Roster;
import shetiphian.enderchests.common.inventory.ContainerEnderChest;
import shetiphian.enderchests.common.inventory.ContainerProviders;
import shetiphian.enderchests.common.item.IOpenable;
import shetiphian.enderchests.common.misc.ChestInfoHelper;
import shetiphian.enderchests.common.misc.StackHelper;
import shetiphian.enderchests.common.tileentity.TileEntityEnderChest;

public class ItemEnderBag
extends Item
implements ITabFiller,
IColored,
IOpenable {
    public ItemEnderBag(Item.Properties properties) {
        super(properties);
        SideExecutor.runOnClient(() -> () -> {
            ColorHandler.colorize((IColored)this);
            ClientHelpers.addProperty((Item)this, (String)"type", (stack, world, entity, seed) -> StackHelper.isPublic(stack) ? 0.0f : (StackHelper.isTeam(stack) ? 2.0f : 1.0f));
            ClientHelpers.addProperty((Item)this, (String)"open", (stack, world, entity, seed) -> IOpenable.isOpen(stack) ? 1.0f : 0.0f);
        });
    }

    public void fillCreativeTab(CreativeModeTab.Output entries, CreativeModeTab.ItemDisplayParameters context) {
        for (String code : StackHelper.BASE_CODES) {
            entries.accept(StackHelper.create(this, code, "all"));
        }
    }

    public void verifyComponentsAfterLoad(ItemStack stack) {
        super.verifyComponentsAfterLoad(stack);
        StackHelper.cleanOutOldNbt(stack);
    }

    public void onCraftedBy(ItemStack stack, Level world, Player player) {
        if (!((Boolean)Configs.ACCESS_SETTINGS.allowPublicBags.get()).booleanValue() && StackHelper.isPublic(stack)) {
            if (!((Boolean)Configs.ACCESS_SETTINGS.allowPersonalBags.get()).booleanValue()) {
                String teamID = Helpers.getPlayerTeamID((Player)player);
                if (!Strings.isNullOrEmpty((String)teamID)) {
                    StackHelper.setOwner(stack, "#" + teamID);
                }
            } else {
                StackHelper.setOwner(stack, player.getUUID().toString());
            }
        }
        IOpenable.setOpenState(stack, false);
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand hand) {
        return this.openInventory(player.getItemInHand(hand), world, player);
    }

    @Override
    public InteractionResultHolder<ItemStack> openInventory(ItemStack stack, Level world, Player player) {
        BlockPos pos;
        boolean isSneaking = player.isShiftKeyDown();
        BlockHitResult mop = ItemEnderBag.getPlayerPOVHitResult((Level)world, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.NONE);
        BlockPos blockPos = pos = mop instanceof BlockHitResult ? mop.getBlockPos() : null;
        if (!world.isClientSide()) {
            if (isSneaking && pos != null && world.getBlockState(pos).getBlock() == Roster.Blocks.ENDERCHEST.get()) {
                BlockEntity tile = world.getBlockEntity(pos);
                if (tile instanceof TileEntityEnderChest) {
                    TileEntityEnderChest chestTile = (TileEntityEnderChest)tile;
                    if (chestTile.hasError()) {
                        ChestInfoHelper.sendLinkError(player, 2);
                    } else {
                        if (chestTile.canLink(player)) {
                            if (((Boolean)Configs.GENERAL.fullStackLinking.get()).booleanValue()) {
                                StackHelper.setLink(stack, chestTile.getCode(), chestTile.getOwnerID());
                            } else {
                                Helpers.giveItem((Player)player, (ItemStack)StackHelper.setLink(stack.split(1), chestTile.getCode(), chestTile.getOwnerID()));
                            }
                            return InteractionResultHolder.success((Object)stack);
                        }
                        ChestInfoHelper.sendLinkError(player, chestTile.isTeam() ? 3 : 1);
                    }
                }
                return InteractionResultHolder.success((Object)stack);
            }
            if (!StackHelper.isPublic(stack) || ((Boolean)Configs.ACCESS_SETTINGS.allowPublicBags.get()).booleanValue()) {
                IOpenable.setOpenState(stack, true);
                String ownerID = StackHelper.getOwnerID(stack);
                String code = StackHelper.getCode(stack);
                if (Strings.isNullOrEmpty((String)ownerID) || Strings.isNullOrEmpty((String)code)) {
                    ChestInfoHelper.sendError(player, "enderchests.bag.corrupted");
                } else {
                    String ownerName = StackHelper.getOwnerName(stack);
                    Services.COMMON.openMenu(player, (MenuProviderWithData)ContainerProviders.EnderBag.create(ownerID, code, ownerName));
                    world.playSound(null, player.getX(), player.getY(), player.getZ(), (SoundEvent)SoundEvents.ARMOR_EQUIP_GENERIC.value(), player.getSoundSource(), 1.0f, 1.0f);
                }
            } else {
                ChestInfoHelper.sendError(player, "enderchests.bag.public.disabled");
            }
        } else if (!(isSneaking && pos != null || StackHelper.isPublic(stack) && !((Boolean)Configs.ACCESS_SETTINGS.allowPublicBags.get()).booleanValue())) {
            IOpenable.setOpenState(stack, true);
        }
        return InteractionResultHolder.success((Object)stack);
    }

    public void inventoryTick(ItemStack stack, Level world, Entity entity, int itemSlot, boolean isSelected) {
        super.inventoryTick(stack, world, entity, itemSlot, isSelected);
        this.iOpenableInventoryTick(stack, entity);
    }

    @Override
    public boolean isContainerOpen(Player player) {
        return player != null && player.containerMenu instanceof ContainerEnderChest;
    }

    public String getDescriptionId(ItemStack stack) {
        return "item.enderchests.bag." + (StackHelper.isPublic(stack) ? "public" : (StackHelper.isTeam(stack) ? "team" : "private"));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.literal((String)" ").append((Component)Component.translatable((String)"info.enderchests.chest.code")).append((Component)Component.literal((String)(" " + StackHelper.getCode(stack)))));
        Component owner = ChestInfoHelper.formatChestOwner(StackHelper.getOwnerName(stack));
        if (owner != null) {
            tooltip.add(owner);
        }
    }

    public int getColorFor(IColored.Data data, int index) {
        if (index > 0 && index < 4 && !data.stack.isEmpty()) {
            int value = Mth.clamp((int)Integer.parseInt("" + StackHelper.getCode(data.stack).charAt(index - 1), 16), (int)0, (int)16);
            return Configs.PROCESSED.colorValues[value];
        }
        return -1;
    }
}

