/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.enderchests.common.inventory;

import com.google.common.base.Strings;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import shetiphian.core.common.inventory.InventoryInternal;
import shetiphian.core.common.inventory.MenuProviderWithData;
import shetiphian.enderchests.common.inventory.ContainerEnderChest;
import shetiphian.enderchests.common.misc.ChestHelper;
import shetiphian.enderchests.common.tileentity.TileEntityEnderChest;

public class ContainerProviders {

    public record EnderBag(Component displayName, String ownerId, String code, String ownerName) implements MenuProviderWithData
    {
        public static EnderBag create(String ownerId, String code, String ownerName) {
            MutableComponent displayName = Component.literal((String)(!Strings.isNullOrEmpty((String)ownerName) ? ownerName.toLowerCase() : "all." + code.toLowerCase()));
            return new EnderBag((Component)displayName, ownerId, code, ownerName);
        }

        public Component getDisplayName() {
            return this.displayName;
        }

        public AbstractContainerMenu createMenu(int id, Inventory playerInv, Player player) {
            return new ContainerEnderChest(id, playerInv, ChestHelper.getChest(player.level(), this.ownerId, this.code), this.ownerName);
        }

        public static ContainerEnderChest createMenu(int id, Inventory inventory, FriendlyByteBuf data) {
            Level world = inventory.player.level();
            InventoryInternal chest = null;
            try {
                chest = ChestHelper.getChest(world, data.readUtf(), data.readUtf());
            }
            catch (Exception exception) {
                // empty catch block
            }
            return chest != null ? new ContainerEnderChest(id, inventory, chest, data.readUtf()) : null;
        }

        public void write(FriendlyByteBuf data) {
            data.writeUtf(this.ownerId);
            data.writeUtf(this.code);
            data.writeUtf(this.ownerName);
        }
    }

    public record EnderChest(Component displayName, TileEntityEnderChest tile) implements MenuProviderWithData
    {
        public static EnderChest create(TileEntityEnderChest tile) {
            MutableComponent displayName = Component.literal((String)(tile.getOwnerName().toLowerCase() + "." + tile.getCode().toLowerCase()));
            return new EnderChest((Component)displayName, tile);
        }

        public Component getDisplayName() {
            return this.displayName;
        }

        public AbstractContainerMenu createMenu(int id, Inventory inventory, Player player) {
            return new ContainerEnderChest(id, inventory, this.tile);
        }

        public static ContainerEnderChest createMenu(int id, Inventory inventory, FriendlyByteBuf data) {
            BlockPos pos = data.readBlockPos();
            Level world = inventory.player.level();
            BlockEntity tile = world.getBlockEntity(pos);
            return tile instanceof TileEntityEnderChest ? new ContainerEnderChest(id, inventory, (TileEntityEnderChest)tile) : null;
        }

        public void write(FriendlyByteBuf data) {
            data.writeBlockPos(this.tile.getBlockPos());
        }
    }
}

