/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.enderchests.client.gui;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import shetiphian.core.client.gui.GuiHelper;
import shetiphian.enderchests.client.gui.Textures;
import shetiphian.enderchests.common.inventory.ContainerEnderChest;
import shetiphian.enderchests.common.inventory.Slots;
import shetiphian.enderchests.common.item.IOpenable;

public class GuiEnderChest
extends AbstractContainerScreen<ContainerEnderChest> {
    private int slotCount;
    private int columns;
    private int rows;
    private int colOffset;

    public GuiEnderChest(ContainerEnderChest container, Inventory inventory, Component title) {
        super((AbstractContainerMenu)container, inventory, title);
        this.imageWidth = 182;
        this.setLayout();
        ((ContainerEnderChest)this.menu).setInventoryChangeCallback(this::setLayout);
    }

    private void setLayout() {
        this.slotCount = ((ContainerEnderChest)this.menu).getChestSize();
        int n = this.columns = this.slotCount >= 27 ? 9 : this.slotCount / 3;
        this.rows = this.slotCount <= 27 ? 3 : (this.slotCount % 9 == 0 ? this.slotCount / 9 : this.slotCount / 9 + 1);
        this.colOffset = (9 - this.columns) * 9;
        int rowOffset = (this.rows - 3) * 18;
        this.imageHeight = 172 + rowOffset;
        this.topPos = (this.height - this.imageHeight) / 2;
        for (Slot invSlot : ((ContainerEnderChest)this.menu).slots) {
            if (invSlot instanceof Slots.Hideable) {
                Slots.Hideable slot = (Slots.Hideable)invSlot;
                int group = slot.getContainerSlot();
                if (slot.getContainerSlot() >= this.slotCount) {
                    slot.setVisible(false);
                    continue;
                }
                slot.setVisible(true);
                int toX = 11 + this.colOffset + group % this.columns * 18;
                int toY = 11 + group / this.columns * 18;
                Slots.moveSlot(slot, toX, toY);
                continue;
            }
            int slotId = invSlot.getContainerSlot();
            int row = slotId / 9 - 1;
            int col = slotId % 9 * 18;
            Slots.moveSlot(invSlot, 11 + col, 87 + rowOffset + (row == -1 ? 58 : row * 18));
        }
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.render(graphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(graphics, mouseX, mouseY);
    }

    protected void renderLabels(GuiGraphics graphics, int mouseX, int mouseY) {
        graphics.drawCenteredString(this.font, ((ContainerEnderChest)this.menu).getOwner(), this.imageWidth / 2, -8, -32961);
    }

    protected void renderBg(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        ResourceLocation guiTexture = Textures.ENDERCHEST.get();
        if (this.slotCount != ((ContainerEnderChest)this.menu).getChestSize()) {
            this.setLayout();
        }
        int ypos = 0;
        if (this.slotCount >= 27) {
            int rem;
            GuiHelper.drawTexture((GuiGraphics)graphics, (double)this.leftPos, (double)(this.topPos + ypos), (int)0, (int)102, (int)182, (int)46, (ResourceLocation)guiTexture);
            GuiHelper.drawTexture((GuiGraphics)graphics, (double)this.leftPos, (double)(this.topPos + (ypos += 46)), (int)0, (int)112, (int)182, (int)(this.rows == 3 ? 18 : 36), (ResourceLocation)guiTexture);
            ypos += this.rows == 3 ? 18 : 36;
            if (this.rows > 4) {
                GuiHelper.drawTexture((GuiGraphics)graphics, (double)this.leftPos, (double)(this.topPos + ypos), (int)0, (int)112, (int)182, (int)(this.rows == 5 ? 18 : 36), (ResourceLocation)guiTexture);
                ypos += this.rows == 5 ? 18 : 36;
            }
            if ((rem = this.slotCount % 9) != 0) {
                int left = rem == 3 ? 64 : 118;
                GuiHelper.drawTexture((GuiGraphics)graphics, (double)(this.leftPos + left), (double)(this.topPos + ypos - 18), (int)left, (int)(this.rows % 2 == 0 ? 82 : 64), (int)(182 - left - 10), (int)18, (ResourceLocation)guiTexture);
            }
            GuiHelper.drawTexture((GuiGraphics)graphics, (double)this.leftPos, (double)(this.topPos + ypos), (int)0, (int)148, (int)182, (int)10, (ResourceLocation)guiTexture);
        } else {
            int left = this.colOffset;
            GuiHelper.drawTexture((GuiGraphics)graphics, (double)(this.leftPos + left), (double)this.topPos, (int)0, (int)102, (int)10, (int)46, (ResourceLocation)guiTexture);
            GuiHelper.drawTexture((GuiGraphics)graphics, (double)(this.leftPos + left), (double)(this.topPos + 46), (int)0, (int)112, (int)10, (int)18, (ResourceLocation)guiTexture);
            GuiHelper.drawTexture((GuiGraphics)graphics, (double)(this.leftPos + left), (double)(this.topPos + 64), (int)0, (int)148, (int)10, (int)10, (ResourceLocation)guiTexture);
            int half = (this.columns / 2 - 1) * 18;
            GuiHelper.drawTexture((GuiGraphics)graphics, (double)(this.leftPos + (left += 10)), (double)this.topPos, (int)(64 - half), (int)102, (int)(this.columns * 18), (int)46, (ResourceLocation)guiTexture);
            GuiHelper.drawTexture((GuiGraphics)graphics, (double)(this.leftPos + left), (double)(this.topPos + 46), (int)(64 - half), (int)112, (int)(this.columns * 18), (int)18, (ResourceLocation)guiTexture);
            GuiHelper.drawTexture((GuiGraphics)graphics, (double)(this.leftPos + left), (double)(this.topPos + 64), (int)(64 - half), (int)148, (int)(this.columns * 18), (int)10, (ResourceLocation)guiTexture);
            GuiHelper.drawTexture((GuiGraphics)graphics, (double)(this.leftPos + (left += this.columns * 18)), (double)this.topPos, (int)172, (int)102, (int)10, (int)46, (ResourceLocation)guiTexture);
            GuiHelper.drawTexture((GuiGraphics)graphics, (double)(this.leftPos + left), (double)(this.topPos + 46), (int)172, (int)112, (int)10, (int)18, (ResourceLocation)guiTexture);
            GuiHelper.drawTexture((GuiGraphics)graphics, (double)(this.leftPos + left), (double)(this.topPos + 64), (int)172, (int)148, (int)10, (int)10, (ResourceLocation)guiTexture);
            ypos += 64;
        }
        GuiHelper.drawTexture((GuiGraphics)graphics, (double)this.leftPos, (double)(this.topPos + (ypos += 10)), (int)0, (int)158, (int)182, (int)98, (ResourceLocation)guiTexture);
    }

    protected void slotClicked(Slot slot, int slotId, int clickedButton, ClickType clickType) {
        ItemStack stack;
        if (slot != null && slot.hasItem() && !(stack = slot.getItem()).isEmpty() && stack.getItem() instanceof IOpenable && IOpenable.isOpen(stack)) {
            return;
        }
        super.slotClicked(slot, slotId, clickedButton, clickType);
    }
}

