/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.enderchests.client;

import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.IExtensionPoint;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.client.event.RenderHighlightEvent;
import net.neoforged.neoforge.client.gui.ConfigurationScreen;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.neoforged.neoforge.common.NeoForge;
import shetiphian.enderchests.Roster;
import shetiphian.enderchests.client.EventHandlerClient;
import shetiphian.enderchests.client.gui.GuiEnderChest;
import shetiphian.enderchests.client.render.RenderEnderChest;

@Mod(value="enderchests", dist={Dist.CLIENT})
public final class ModMainClient {
    public ModMainClient(ModContainer modContainer, IEventBus modEventBus) {
        modContainer.registerExtensionPoint(IConfigScreenFactory.class, (IExtensionPoint)((IConfigScreenFactory)ConfigurationScreen::new));
        modEventBus.register((Object)new ModBusEvents());
        NeoForge.EVENT_BUS.register((Object)new EventRelay());
    }

    private static class ModBusEvents {
        private ModBusEvents() {
        }

        @SubscribeEvent
        public void registerBindings(RegisterKeyMappingsEvent event) {
            event.register(EventHandlerClient.KEY_OPEN_BAG);
            event.register(EventHandlerClient.KEY_OPEN_POUCH);
        }

        @SubscribeEvent
        public void registerScreenFactories(RegisterMenuScreensEvent event) {
            event.register((MenuType)Roster.Containers.ENDER_BAG.get(), GuiEnderChest::new);
            event.register((MenuType)Roster.Containers.ENDER_CHEST.get(), GuiEnderChest::new);
        }

        @SubscribeEvent
        public void entityRenderersEvent(EntityRenderersEvent.RegisterRenderers event) {
            event.registerBlockEntityRenderer((BlockEntityType)Roster.Tiles.ENDERCHEST.get(), context -> new RenderEnderChest());
        }
    }

    private static class EventRelay
    extends EventHandlerClient {
        private EventRelay() {
        }

        @SubscribeEvent
        public void clientTick(ClientTickEvent.Post event) {
            this.onClientTick();
        }

        @SubscribeEvent
        public void drawBlockHighlightEvent(RenderHighlightEvent.Block event) {
            this.onDrawBlockHighlight(event.getTarget(), event.getPoseStack(), event.getMultiBufferSource(), event.getCamera());
        }
    }
}

