/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.enderchests;

import com.google.common.base.Function;
import java.util.Objects;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.LevelResource;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.InterModEnqueueEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.TagsUpdatedEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.level.LevelEvent;
import net.neoforged.neoforge.event.server.ServerAboutToStartEvent;
import net.neoforged.neoforge.event.server.ServerStoppedEvent;
import shetiphian.enderchests.ConfigLoader;
import shetiphian.enderchests.Configs;
import shetiphian.enderchests.EnderChests;
import shetiphian.enderchests.Registration;
import shetiphian.enderchests.common.EventHandler;
import shetiphian.enderchests.common.misc.ChestHelper;
import shetiphian.enderchests.modintegration.ModIntegration;
import shetiphian.enderchests.network.NetworkHandler;

@Mod(value="enderchests")
public final class ModMain {
    public ModMain(ModContainer modContainer, IEventBus modEventBus) {
        new Registration(modEventBus);
        new ConfigLoader(modContainer, modEventBus);
        modEventBus.addListener(NetworkHandler::initialise);
        modEventBus.addListener(InterModEnqueueEvent.class, event -> ModIntegration.INSTANCE.init());
        NeoForge.EVENT_BUS.register((Object)new EventRelay());
        EnderChests.CAPABILITY_DEVALID_INATOR = tile -> {
            try {
                Objects.requireNonNull(tile.getLevel()).invalidateCapabilities(tile.getBlockPos());
            }
            catch (Exception exception) {
                // empty catch block
            }
        };
    }

    private static class EventRelay
    extends EventHandler {
        private MinecraftServer bufferedServer = null;

        private EventRelay() {
        }

        @SubscribeEvent
        public void serverStarting(ServerAboutToStartEvent event) {
            this.bufferedServer = event.getServer();
        }

        @SubscribeEvent
        public void serverStopped(ServerStoppedEvent event) {
            ChestHelper.INSTANCE.unloadChestData();
            Configs.CAN_PROCESS_TAGS = false;
        }

        @SubscribeEvent
        public void worldLoaded(LevelEvent.Load event) {
            ServerLevel world;
            if (this.bufferedServer != null && (world = this.bufferedServer.getLevel(Level.OVERWORLD)) != null) {
                ChestHelper.INSTANCE.onWorldLoad(this.bufferedServer, world, (Function<String, LevelResource>)((Function)LevelResource::new));
                this.bufferedServer = null;
            }
        }

        @SubscribeEvent
        public void tagsUpdatedEvent(TagsUpdatedEvent event) {
            EventRelay.onTagsUpdated();
        }

        @SubscribeEvent
        public void playerRightClickBlockEvent(PlayerInteractEvent.RightClickBlock event) {
            InteractionResult result = EventRelay.onPlayerRightClickBlock(event.getEntity(), event.getLevel(), event.getPos(), event.getHand());
            if (result.consumesAction()) {
                event.setCanceled(true);
                event.setCancellationResult(InteractionResult.SUCCESS);
            }
        }
    }
}

