/*
 * Decompiled with CFR 0.152.
 */
package rikka.lanserverproperties;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.world.level.GameType;

public class Preferences {
    private static final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    private static final String preferenceFileName = "lsp.json";
    public boolean enablePreference = true;
    public GameType gameMode = GameType.SURVIVAL;
    public boolean allowCheat = false;
    public int defaultPort = 25565;
    public boolean onlineMode = true;
    public boolean fixUUID = true;
    public boolean allowPVP = true;
    public int maxPlayer = 8;
    public List<String> playersAlwaysOffline = new LinkedList<String>();

    public static Path getConfigFolder() {
        return Minecraft.getInstance().gameDirectory.toPath().resolve("config");
    }

    public static Path getFileName() {
        return Preferences.getConfigFolder().resolve(preferenceFileName);
    }

    public static String getAlwaysOfflineString(List<String> playerList) {
        Iterator<String> iterator = playerList.iterator();
        Object result = "";
        if (iterator.hasNext()) {
            result = iterator.next();
        } else {
            return result;
        }
        while (iterator.hasNext()) {
            result = (String)result + " " + iterator.next();
        }
        return result;
    }

    public static List<String> listOfAlwaysOffline(String alwaysOfflines) {
        return Arrays.stream(alwaysOfflines.split(" ")).toList();
    }

    public boolean save() {
        try {
            Files.createDirectories(Preferences.getConfigFolder(), new FileAttribute[0]);
            BufferedWriter writer = Files.newBufferedWriter(Preferences.getFileName(), new OpenOption[0]);
            gson.toJson((Object)this, (Appendable)writer);
            ((Writer)writer).flush();
            ((Writer)writer).close();
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static Preferences read() {
        Preferences ret = null;
        try {
            BufferedReader reader = Files.newBufferedReader(Preferences.getFileName());
            ret = (Preferences)gson.fromJson((Reader)reader, Preferences.class);
            ((Reader)reader).close();
        }
        catch (NoSuchFileException reader) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret == null ? new Preferences() : ret;
    }
}

