/*
 * Decompiled with CFR 0.152.
 */
package rikka.lanserverproperties;

import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.SpriteIconButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.ShareToLanScreen;
import net.minecraft.client.server.IntegratedServer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceLocation;
import rikka.lanserverproperties.CommonWidgets;
import rikka.lanserverproperties.ConfigContainer;
import rikka.lanserverproperties.IShareToLanScreenParamAccessor;
import rikka.lanserverproperties.ModifyLanScreen;

public class OpenToLanScreenEx {
    private static final Component lanServerOptionsLabel = Component.translatable((String)"lanserverproperties.button.lan_server_options");
    private static final Component portDescLabel = Component.translatable((String)"lanserverproperties.gui.port");
    private final ShareToLanScreen screen;
    private final IShareToLanScreenParamAccessor stlParamAccessor;
    private Button startButton = null;
    private ConfigContainer configContainer;
    private CommonWidgets commonWidgets;

    public OpenToLanScreenEx(ShareToLanScreen screen, IShareToLanScreenParamAccessor stlParamAccessor) {
        this.screen = screen;
        this.stlParamAccessor = stlParamAccessor;
        this.configContainer = new ConfigContainer.Vanilla(stlParamAccessor);
    }

    private static <T extends AbstractWidget> T findWidget(List<? extends GuiEventListener> list, Class<T> cls, String vanillaLangKey) {
        for (GuiEventListener guiEventListener : list) {
            Component component;
            AbstractWidget widget;
            if (!(guiEventListener instanceof AbstractWidget) || !cls.isAssignableFrom((widget = (AbstractWidget)guiEventListener).getClass()) || !((component = widget.getMessage()).getContents() instanceof TranslatableContents)) continue;
            TranslatableContents content = (TranslatableContents)component.getContents();
            if (content.getKey().equals(vanillaLangKey)) {
                return (T)widget;
            }
            Object[] args = content.getArgs();
            if (args.length == 0 || !(args[0] instanceof MutableComponent)) continue;
            MutableComponent mutableComponent = (MutableComponent)args[0];
            if (!(component.getContents() instanceof TranslatableContents) || !(mutableComponent.getContents() instanceof TranslatableContents) || !(content = (TranslatableContents)mutableComponent.getContents()).getKey().equals(vanillaLangKey)) continue;
            return (T)widget;
        }
        return null;
    }

    private static CycleButton<Boolean> findAllowCommandToggleButton(List<? extends GuiEventListener> list) {
        CycleButton allowCommandsSelector = OpenToLanScreenEx.findWidget(list, CycleButton.class, "selectWorld.allowCommands.new");
        return allowCommandsSelector == null ? OpenToLanScreenEx.findWidget(list, CycleButton.class, "selectWorld.allowCommands") : allowCommandsSelector;
    }

    public void postInitShareToLanScreen(Font textRenderer, List<? extends GuiEventListener> list, Consumer<GuiEventListener> widgetAdder, Consumer<GuiEventListener> widgetRemover) {
        Minecraft mc = Minecraft.getInstance();
        if (!mc.hasSingleplayerServer()) {
            return;
        }
        this.configContainer.loadFromPreferences(false);
        this.startButton = OpenToLanScreenEx.findWidget(list, Button.class, "lanServer.start");
        final CycleButton<Boolean> allowCommandsSelector = OpenToLanScreenEx.findAllowCommandToggleButton(list);
        final CycleButton gameModeSelector = OpenToLanScreenEx.findWidget(list, CycleButton.class, "selectWorld.gameMode");
        final EditBox portEdit = OpenToLanScreenEx.findWidget(list, EditBox.class, "lanServer.port");
        this.commonWidgets = new CommonWidgets((Screen)this.screen, this.configContainer, textRenderer, widgetAdder){

            @Override
            protected void onButtonStatusUpdated(boolean shouldEnableButtons) {
                OpenToLanScreenEx.this.startButton.active = shouldEnableButtons;
            }

            @Override
            public void syncWidgetValues() {
                super.syncWidgetValues();
                allowCommandsSelector.setValue((Object)OpenToLanScreenEx.this.configContainer.getGuiCommandEnabled());
                gameModeSelector.setValue((Object)OpenToLanScreenEx.this.configContainer.getGuiGameType());
                portEdit.setValue(String.valueOf(OpenToLanScreenEx.this.configContainer.getGuiPort()));
            }
        };
        this.commonWidgets.syncWidgetValues();
        this.stlParamAccessor.movePortEditBox(this.screen.width / 2 - 154, this.screen.height - 54, 147, 20);
    }

    public static void initPauseScreen(Screen gui, List<? extends GuiEventListener> list, Consumer<GuiEventListener> widgetAdder) {
        Button optionButton;
        Minecraft mc = Minecraft.getInstance();
        Button shareToLanButton = OpenToLanScreenEx.findWidget(list, Button.class, "menu.shareToLan");
        if (shareToLanButton != null) {
            shareToLanButton.active = mc.hasSingleplayerServer();
        }
        if (mc.hasSingleplayerServer() && mc.getSingleplayerServer().isPublished() && (optionButton = OpenToLanScreenEx.findWidget(list, Button.class, "menu.options")) != null) {
            SpriteIconButton lanServerSettings = SpriteIconButton.builder((Component)lanServerOptionsLabel, button -> mc.setScreen((Screen)new ModifyLanScreen(gui)), (boolean)true).width(20).sprite(ResourceLocation.tryParse((String)"icon/language"), 15, 15).build();
            lanServerSettings.setPosition(gui.width / 2 - 124, optionButton.getY());
            lanServerSettings.setTooltip(Tooltip.create((Component)lanServerOptionsLabel));
            widgetAdder.accept((GuiEventListener)lanServerSettings);
        }
    }

    public static void postDraw(Screen gui, Font textRenderer, GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.hasSingleplayerServer()) {
            guiGraphics.drawString(textRenderer, portDescLabel, gui.width / 2 - 155, gui.height - 66, 0xA0A0A0);
            guiGraphics.drawString(textRenderer, ModifyLanScreen.maxPlayerDescLabel, gui.width / 2 + 5, gui.height - 66, 0xA0A0A0);
        }
    }

    public void onPortEditBoxChanged() {
        this.commonWidgets.updateButtonStatus(this.startButton.active);
    }

    public int getDefaultPort() {
        return this.configContainer.preferences.defaultPort;
    }

    public void onOpenToLanClosed() {
        IntegratedServer server = Minecraft.getInstance().getSingleplayerServer();
        this.configContainer.applyToCurrentServer(server);
    }
}

