/*
 * Decompiled with CFR 0.152.
 */
package rikka.lanserverproperties;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.server.IntegratedServer;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.GameType;
import rikka.lanserverproperties.CommonWidgets;
import rikka.lanserverproperties.ConfigContainer;

public class ModifyLanScreen
extends Screen {
    private static final Component ALLOW_COMMANDS_LABEL = Component.translatable((String)"selectWorld.allowCommands");
    private static final Component GAME_MODE_LABEL = Component.translatable((String)"selectWorld.gameMode");
    private static final Component INFO_TEXT = Component.translatable((String)"lanServer.otherPlayers");
    private static final Component portListeningLabel = Component.translatable((String)"lanserverproperties.gui.port_listening");
    public static final Component maxPlayerDescLabel = Component.translatable((String)"lanserverproperties.gui.max_player");
    public final Screen lastScreen;
    protected EditBox portEdit;
    private final ConfigContainer.Modded configContainer = new ConfigContainer.Modded();

    protected ModifyLanScreen(Screen lastScreen) {
        super((Component)Component.translatable((String)"lanServer.title"));
        this.lastScreen = lastScreen;
    }

    protected void init() {
        IntegratedServer server = this.minecraft.getSingleplayerServer();
        this.configContainer.loadFromCurrentServer(server);
        final CycleButton gameModeSelector = CycleButton.builder(GameType::getShortDisplayName).withValues((Object[])new GameType[]{GameType.SURVIVAL, GameType.SPECTATOR, GameType.CREATIVE, GameType.ADVENTURE}).withInitialValue((Object)this.configContainer.getGuiGameType()).create(this.width / 2 - 155, 100, 150, 20, GAME_MODE_LABEL, (oldValue, newValue) -> this.configContainer.setGameType((GameType)newValue));
        this.addRenderableWidget((GuiEventListener)gameModeSelector);
        final CycleButton allowCommandsSelector = CycleButton.onOffBuilder((boolean)this.configContainer.getGuiCommandEnabled()).create(this.width / 2 + 5, 100, 150, 20, ALLOW_COMMANDS_LABEL, (oldValue, newValue) -> this.configContainer.setCommandEnabled((boolean)newValue));
        this.addRenderableWidget((GuiEventListener)allowCommandsSelector);
        this.portEdit = new EditBox(this.font, this.width / 2 - 154, this.height - 54, 147, 20, (Component)Component.translatable((String)"lanServer.port"));
        this.portEdit.setEditable(false);
        this.portEdit.setValue(String.valueOf(server.getPort()));
        this.portEdit.setTooltip(null);
        this.portEdit.setResponder(null);
        this.addRenderableWidget((GuiEventListener)this.portEdit);
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)CommonComponents.GUI_CANCEL, p_280824_ -> this.minecraft.setScreen(this.lastScreen)).bounds(this.width / 2 + 5, this.height - 28, 150, 20).build());
        final Button doneButton = Button.builder((Component)CommonComponents.GUI_DONE, btn -> {
            this.configContainer.applyToCurrentServer(server);
            Minecraft.getInstance().setScreen(this.lastScreen);
        }).bounds(this.width / 2 - 155, this.height - 28, 150, 20).build();
        this.addRenderableWidget((GuiEventListener)doneButton);
        new CommonWidgets(this, this.configContainer, this.font, this::widgetAdder){

            @Override
            protected void onButtonStatusUpdated(boolean shouldEnableButtons) {
                doneButton.active = shouldEnableButtons;
            }

            @Override
            public void syncWidgetValues() {
                super.syncWidgetValues();
                allowCommandsSelector.setValue((Object)ModifyLanScreen.this.configContainer.getGuiCommandEnabled());
                gameModeSelector.setValue((Object)ModifyLanScreen.this.configContainer.getGuiGameType());
                ModifyLanScreen.this.portEdit.setValue(String.valueOf(ModifyLanScreen.this.configContainer.getGuiPort()));
            }
        };
    }

    private <T extends GuiEventListener & Renderable> void widgetAdder(GuiEventListener widget) {
        this.addRenderableWidget(widget);
    }

    public void render(GuiGraphics guiGraphics, int p_96653_, int p_96654_, float p_96655_) {
        guiGraphics.drawCenteredString(this.font, this.title, this.width / 2, 50, 0xFFFFFF);
        guiGraphics.drawCenteredString(this.font, INFO_TEXT, this.width / 2, 82, 0xFFFFFF);
        guiGraphics.drawString(this.font, portListeningLabel, this.width / 2 - 155, this.height - 66, 0xA0A0A0);
        guiGraphics.drawString(this.font, maxPlayerDescLabel, this.width / 2 + 5, this.height - 66, 0xA0A0A0);
        super.render(guiGraphics, p_96653_, p_96654_, p_96655_);
    }
}

