/*
 * Decompiled with CFR 0.152.
 */
package rikka.lanserverproperties;

import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.SpriteIconButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import rikka.lanserverproperties.ConfigContainer;
import rikka.lanserverproperties.IntegerEditBox;
import rikka.lanserverproperties.OnlineMode;

public abstract class CommonWidgets {
    private static final Component preferenceEnabledLabel = Component.translatable((String)"lanserverproperties.options.preference_enabled");
    private static final Component preferenceEnabledTooltip = Component.translatable((String)"lanserverproperties.options.preference_enabled.message");
    private static final Component preferenceLoadLabel = Component.translatable((String)"lanserverproperties.button.preference_load");
    private static final Component preferenceSaveLabel = Component.translatable((String)"lanserverproperties.button.preference_save");
    private static final Component pvpAllowedLabel = Component.translatable((String)"lanserverproperties.gui.pvp_allowed");
    private static final Component maxPlayerDescLabel = Component.translatable((String)"lanserverproperties.gui.max_player");
    private static final Component alwaysOfflineLabel = Component.translatable((String)"lanserverproperties.gui.always_offline");
    private static final Component alwaysOfflineDescLabel = Component.translatable((String)"lanserverproperties.gui.always_offline.message");
    private static final Function<String, Boolean> maxPlayerValidator = IntegerEditBox.makeValidator(0, 16);
    private static final WidgetSprites PAGE_FORWARD_SPRITES = new WidgetSprites(ResourceLocation.tryParse((String)"recipe_book/page_forward"), ResourceLocation.tryParse((String)"recipe_book/page_forward_highlighted"));
    private final Button savePreferenceButton;
    private final CycleButton<Boolean> enablePreferenceOption;
    private final CycleButton<OnlineMode> onlineModeOption;
    private final CycleButton<Boolean> pvpAllowedOption;
    private final IntegerEditBox maxPlayerEditBox;
    private final EditBox alwaysOfflinesEditBox;
    private final ConfigContainer configContainer;

    public CommonWidgets(Screen screen, ConfigContainer configContainer, Font textRenderer, Consumer<GuiEventListener> widgetAdder) {
        this.configContainer = configContainer;
        this.savePreferenceButton = Button.builder((Component)preferenceSaveLabel, btn -> {
            configContainer.copyToPreferences();
            configContainer.preferences.save();
        }).bounds(screen.width / 2 - 155, 16, 150, 20).build();
        widgetAdder.accept((GuiEventListener)this.savePreferenceButton);
        this.enablePreferenceOption = CycleButton.onOffBuilder().withInitialValue((Object)configContainer.preferences.enablePreference).withTooltip(curState -> Tooltip.create((Component)preferenceEnabledTooltip)).create(screen.width / 2 + 5, 16, 150, 20, preferenceEnabledLabel, (cycleButton, newVal) -> {
            configContainer.preferences.enablePreference = newVal;
        });
        widgetAdder.accept((GuiEventListener)this.enablePreferenceOption);
        this.onlineModeOption = new CycleButton.Builder(state -> state.stateName).withValues((Object[])OnlineMode.values()).withInitialValue((Object)configContainer.onlineMode).withTooltip(curState -> Tooltip.create((Component)curState.tooltip)).displayOnlyValue().create(screen.width / 2 - 155, 124, 150, 20, OnlineMode.translation, (dummyButton, newVal) -> {
            configContainer.onlineMode = newVal;
        });
        widgetAdder.accept((GuiEventListener)this.onlineModeOption);
        this.pvpAllowedOption = CycleButton.onOffBuilder((boolean)configContainer.pvpAllowed).create(screen.width / 2 + 5, 124, 150, 20, pvpAllowedLabel, (dummyButton, newVal) -> {
            configContainer.pvpAllowed = newVal;
        });
        widgetAdder.accept((GuiEventListener)this.pvpAllowedOption);
        this.maxPlayerEditBox = new IntegerEditBox(textRenderer, screen.width / 2 + 5, screen.height - 54, 147, 20, maxPlayerDescLabel, configContainer.maxPlayer, ieb -> {
            this.updateButtonStatus();
            if (ieb.isContentValid()) {
                configContainer.maxPlayer = ieb.getValueAsInt();
            }
        }, maxPlayerValidator, null);
        widgetAdder.accept((GuiEventListener)this.maxPlayerEditBox);
        this.alwaysOfflinesEditBox = new EditBox(textRenderer, screen.width / 2 - 180, 146, 360, 20, alwaysOfflineLabel);
        this.alwaysOfflinesEditBox.setVisible(false);
        this.alwaysOfflinesEditBox.setTooltip(Tooltip.create((Component)alwaysOfflineDescLabel));
        this.alwaysOfflinesEditBox.setMaxLength(1024);
        this.alwaysOfflinesEditBox.setValue(configContainer.playersAlwaysOffline);
        this.alwaysOfflinesEditBox.setResponder(newValue -> {
            configContainer.playersAlwaysOffline = newValue;
        });
        widgetAdder.accept((GuiEventListener)this.alwaysOfflinesEditBox);
        SpriteIconButton showAOEButton = SpriteIconButton.builder((Component)alwaysOfflineLabel, button -> this.alwaysOfflinesEditBox.visible ^= true, (boolean)true).width(20).sprite(ResourceLocation.tryParse((String)"icon/accessibility"), 15, 15).build();
        showAOEButton.setPosition(screen.width / 2 - 180, 124);
        showAOEButton.setTooltip(Tooltip.create((Component)alwaysOfflineLabel));
        widgetAdder.accept((GuiEventListener)showAOEButton);
        ImageButton loadPrefButton = new ImageButton(screen.width / 2 - 180, 16, 12, 18, PAGE_FORWARD_SPRITES, button -> {
            configContainer.loadFromPreferences(true);
            this.syncWidgetValues();
        }, preferenceLoadLabel);
        loadPrefButton.setTooltip(Tooltip.create((Component)preferenceLoadLabel));
        widgetAdder.accept((GuiEventListener)loadPrefButton);
    }

    public void syncWidgetValues() {
        this.enablePreferenceOption.setValue((Object)this.configContainer.preferences.enablePreference);
        this.onlineModeOption.setValue((Object)this.configContainer.onlineMode);
        this.pvpAllowedOption.setValue((Object)this.configContainer.pvpAllowed);
        this.maxPlayerEditBox.setValue("" + this.configContainer.maxPlayer);
        this.alwaysOfflinesEditBox.setValue(this.configContainer.playersAlwaysOffline);
    }

    protected abstract void onButtonStatusUpdated(boolean var1);

    public void updateButtonStatus() {
        this.updateButtonStatus(true);
    }

    public void updateButtonStatus(boolean lastPortValidity) {
        boolean shouldEnableButtons = lastPortValidity && this.maxPlayerEditBox.isContentValid();
        Minecraft mc = Minecraft.getInstance();
        if (!mc.hasSingleplayerServer()) {
            return;
        }
        this.onButtonStatusUpdated(shouldEnableButtons);
        this.savePreferenceButton.active = shouldEnableButtons;
    }
}

